/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.core.management;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.management.Capabilities;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.extension.core.management.CoreManagementExtension;
import org.wildfly.extension.core.management.ProcessStateListenerService;
import org.wildfly.extension.core.management.client.ProcessStateListener;
import org.wildfly.extension.core.management.logging.CoreManagementLogger;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;

public class ProcessStateListenerResourceDefinition
extends PersistentResourceDefinition {
    private static final String CLASS = "class";
    private static final String PROCESS_STATE_LISTENER_CAPABILITY_NAME = "org.wildfly.extension.core-management.process-state";
    static final RuntimeCapability<Void> PROCESS_STATE_LISTENER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.core-management.process-state", (boolean)true, Void.class).addRequirements(new NullaryServiceDescriptor[]{Capabilities.MANAGEMENT_EXECUTOR, ProcessStateNotifier.SERVICE_DESCRIPTOR}).build();
    public static final PropertiesAttributeDefinition PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("properties", true).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition LISTENER_CLASS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"class", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).setRestartAllServices()).build();
    public static final AttributeDefinition LISTENER_MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).setRestartAllServices()).build();
    public static final AttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(30))).setMeasurementUnit(MeasurementUnit.SECONDS)).setRestartAllServices()).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{LISTENER_CLASS, LISTENER_MODULE, PROPERTIES, TIMEOUT};

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
    }

    ProcessStateListenerResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(CoreManagementExtension.PROCESS_STATE_LISTENER_PATH, CoreManagementExtension.getResourceDescriptionResolver("process-state-listener")).setOrderedChild().setCapabilities(new RuntimeCapability[]{PROCESS_STATE_LISTENER_CAPABILITY}).setAddHandler((OperationStepHandler)new ProcessStateListenerAddHandler()).setRemoveHandler((OperationStepHandler)new ProcessStateListenerRemoveHandler()));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    private static class ProcessStateListenerRemoveHandler
    extends AbstractRemoveStepHandler {
        private ProcessStateListenerRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            context.removeService(PROCESS_STATE_LISTENER_CAPABILITY.getCapabilityServiceName(new String[]{context.getCurrentAddressValue()}));
        }
    }

    private static class ProcessStateListenerAddHandler
    extends AbstractAddStepHandler {
        ProcessStateListenerAddHandler() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String className = LISTENER_CLASS.resolveModelAttribute(context, model).asString();
            String moduleIdentifier = LISTENER_MODULE.resolveModelAttribute(context, model).asString();
            ProcessStateListener listener = ProcessStateListenerAddHandler.newInstance(className, moduleIdentifier);
            Map properties = PROPERTIES.unwrap((ExpressionResolver)context, model);
            int timeout = TIMEOUT.resolveModelAttribute(context, model).asInt();
            ProcessStateListenerService.install(context.getCapabilityServiceTarget(), context.getProcessType(), context.getRunningMode(), context.getCurrentAddress().getLastElement().getValue(), listener, properties, timeout);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return super.requiresRuntime(context) || context.getProcessType().isServer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ProcessStateListener newInstance(String className, String moduleIdentifier) throws OperationFailedException {
            try {
                Object instance;
                Module module = Module.getContextModuleLoader().loadModule(moduleIdentifier);
                Class clazz = module.getClassLoader().loadClass(className);
                ClassLoader currentTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
                    instance = clazz.getConstructor(null).newInstance(null);
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)currentTccl);
                }
                return (ProcessStateListener)ProcessStateListener.class.cast(instance);
            }
            catch (ModuleLoadException e) {
                throw CoreManagementLogger.ROOT_LOGGER.errorToLoadModule(moduleIdentifier);
            }
            catch (ClassNotFoundException e) {
                throw CoreManagementLogger.ROOT_LOGGER.errorToLoadModuleClass(className, moduleIdentifier);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw CoreManagementLogger.ROOT_LOGGER.errorToInstantiateClassInstanceFromModule(className, moduleIdentifier);
            }
        }
    }
}

