/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.enterprise.concurrent.internal.ManagedFutureTask;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.jboss.as.ee.concurrent.SecurityIdentityUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ManagedThreadFactoryImpl
extends org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl {
    private final int priority;
    private final AccessControlContext accessControlContext;

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService, int priority) {
        super(name, contextService, priority);
        this.priority = priority;
        this.accessControlContext = AccessController.getContext();
    }

    public int getPriority() {
        return this.priority;
    }

    protected AbstractManagedThread createThread(Runnable r, ContextHandle contextHandleForSetup) {
        if (contextHandleForSetup != null) {
            r = SecurityIdentityUtils.doIdentityWrap(r);
        }
        AbstractManagedThread t = AccessController.doPrivileged(new CreateThreadAction(r, contextHandleForSetup), this.accessControlContext);
        if (!WildFlySecurityManager.isChecking()) {
            t.setContextClassLoader(null);
        } else {
            AccessController.doPrivileged(() -> {
                t.setContextClassLoader(null);
                return null;
            });
        }
        return t;
    }

    public void taskStarting(Thread t, ManagedFutureTask task) {
        super.taskStarting(t, task);
        if (t instanceof ManagedThread) {
            ((ManagedThread)((Object)t)).task = task;
        }
    }

    public void taskDone(Thread t) {
        super.taskDone(t);
        if (t instanceof ManagedThread) {
            ((ManagedThread)((Object)t)).task = null;
        }
    }

    private final class CreateThreadAction
    implements PrivilegedAction<AbstractManagedThread> {
        private final Runnable r;
        private final ContextHandle contextHandleForSetup;

        private CreateThreadAction(Runnable r, ContextHandle contextHandleForSetup) {
            this.r = r;
            this.contextHandleForSetup = contextHandleForSetup;
        }

        @Override
        public AbstractManagedThread run() {
            return new ManagedThread(this.r, this.contextHandleForSetup);
        }
    }

    public class ManagedThread
    extends ManagedThreadFactoryImpl.ManagedThread {
        volatile ManagedFutureTask task;

        public ManagedThread(Runnable target, ContextHandle contextHandleForSetup) {
            super((org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl)ManagedThreadFactoryImpl.this, target, contextHandleForSetup);
            this.task = null;
        }

        boolean cancelTask() {
            ManagedFutureTask task = this.task;
            if (task != null) {
                return task.cancel(true);
            }
            return false;
        }
    }
}

