/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.BindingDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.RequestLogDTO;

@XmlRootElement(name="web")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WebServerDTO
extends ComponentDTO {
    @Deprecated
    @XmlAttribute
    public String bind;
    @XmlAttribute(required=true)
    public String path;
    @Deprecated
    @XmlAttribute
    public Boolean clientAuth;
    @Deprecated
    @XmlAttribute
    public String passwordCodec;
    @Deprecated
    @XmlAttribute
    public String keyStorePath;
    @Deprecated
    @XmlAttribute
    public String trustStorePath;
    @XmlAttribute
    public String customizer;
    @XmlElementRef
    private List<BindingDTO> bindings;
    @Deprecated
    @XmlElementRef
    public List<AppDTO> apps;
    @XmlElementRef(required=false)
    public RequestLogDTO requestLog;
    @Deprecated
    @XmlAttribute
    private String keyStorePassword;
    @Deprecated
    @XmlAttribute
    private String trustStorePassword;
    @Deprecated
    @XmlAttribute
    private String includedTLSProtocols;
    @Deprecated
    @XmlAttribute
    private String excludedTLSProtocols;
    @Deprecated
    @XmlAttribute
    private String includedCipherSuites;
    @Deprecated
    @XmlAttribute
    private String excludedCipherSuites;
    @XmlAttribute
    public String rootRedirectLocation;
    @XmlAttribute
    public Boolean webContentEnabled;
    @XmlAttribute
    public Integer maxThreads = 200;
    @XmlAttribute
    public Integer minThreads = Math.min(8, this.maxThreads);
    @XmlAttribute
    public Integer idleThreadTimeout = 60000;
    @XmlAttribute
    public Integer scanPeriod;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(String customizer) {
        this.customizer = customizer;
    }

    public RequestLogDTO getRequestLog() {
        return this.requestLog;
    }

    public void setRequestLog(RequestLogDTO requestLog) {
        this.requestLog = requestLog;
    }

    public String getRootRedirectLocation() {
        return this.rootRedirectLocation;
    }

    public void setRootRedirectLocation(String rootRedirectLocation) {
        this.rootRedirectLocation = rootRedirectLocation;
    }

    public Boolean getWebContentEnabled() {
        return this.webContentEnabled;
    }

    public void setWebContentEnabled(Boolean webContentEnabled) {
        this.webContentEnabled = webContentEnabled;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getIdleThreadTimeout() {
        return this.idleThreadTimeout;
    }

    public void setIdleThreadTimeout(Integer idleThreadTimeout) {
        this.idleThreadTimeout = idleThreadTimeout;
    }

    public Integer getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(Integer scanPeriod) {
        this.scanPeriod = scanPeriod;
    }

    public List<BindingDTO> getBindings() {
        return this.bindings;
    }

    public void addBinding(BindingDTO binding) {
        this.bindings.add(binding);
    }

    public WebServerDTO() {
        this.componentClassName = "org.apache.activemq.artemis.component.WebServerComponent";
        this.bindings = new ArrayList<BindingDTO>();
        this.requestLog = new RequestLogDTO();
    }

    public List<BindingDTO> getAllBindings() {
        if (this.bindings == null || this.bindings.isEmpty()) {
            return Collections.singletonList(this.convertToBindingDTO());
        }
        return this.bindings;
    }

    public void setBindings(List<BindingDTO> bindings) {
        this.bindings = bindings;
    }

    private BindingDTO convertToBindingDTO() {
        BindingDTO bindingDTO = new BindingDTO();
        bindingDTO.uri = this.bind;
        bindingDTO.apps = this.apps;
        bindingDTO.clientAuth = this.clientAuth;
        bindingDTO.passwordCodec = this.passwordCodec;
        bindingDTO.keyStorePath = this.keyStorePath;
        bindingDTO.setKeyStorePassword(this.keyStorePassword);
        bindingDTO.trustStorePath = this.trustStorePath;
        bindingDTO.setTrustStorePassword(this.trustStorePassword);
        bindingDTO.setIncludedTLSProtocols(this.includedTLSProtocols);
        bindingDTO.setExcludedTLSProtocols(this.excludedTLSProtocols);
        bindingDTO.setIncludedCipherSuites(this.includedCipherSuites);
        bindingDTO.setExcludedCipherSuites(this.excludedCipherSuites);
        return bindingDTO;
    }

    public BindingDTO getDefaultBinding() {
        return this.getAllBindings().get(0);
    }
}

