/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.store.AlreadyClosedException;

public abstract class TaxonomyReader
implements Closeable {
    public static final int ROOT_ORDINAL = 0;
    public static final int INVALID_ORDINAL = -1;
    private volatile boolean closed = false;
    private final AtomicInteger refCount = new AtomicInteger(1);

    public static <T extends TaxonomyReader> T openIfChanged(T oldTaxoReader) throws IOException {
        TaxonomyReader newTaxoReader = oldTaxoReader.doOpenIfChanged();
        assert (newTaxoReader != oldTaxoReader);
        return (T)newTaxoReader;
    }

    protected abstract void doClose() throws IOException;

    protected abstract TaxonomyReader doOpenIfChanged() throws IOException;

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.getRefCount() <= 0) {
            throw new AlreadyClosedException("this TaxonomyReader is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            TaxonomyReader taxonomyReader = this;
            synchronized (taxonomyReader) {
                if (!this.closed) {
                    this.decRef();
                    this.closed = true;
                }
            }
        }
    }

    public final void decRef() throws IOException {
        this.ensureOpen();
        int rc = this.refCount.decrementAndGet();
        if (rc == 0) {
            boolean success = false;
            try {
                this.doClose();
                this.closed = true;
                success = true;
            }
            finally {
                if (!success) {
                    this.refCount.incrementAndGet();
                }
            }
        } else if (rc < 0) {
            throw new IllegalStateException("too many decRef calls: refCount is " + rc + " after decrement");
        }
    }

    public abstract ParallelTaxonomyArrays getParallelTaxonomyArrays() throws IOException;

    public ChildrenIterator getChildren(int ordinal) throws IOException {
        ParallelTaxonomyArrays arrays = this.getParallelTaxonomyArrays();
        int child = ordinal >= 0 ? arrays.children()[ordinal] : -1;
        return new ChildrenIterator(child, arrays.siblings());
    }

    public abstract Map<String, String> getCommitUserData() throws IOException;

    public abstract int getOrdinal(FacetLabel var1) throws IOException;

    public int[] getBulkOrdinals(FacetLabel ... categoryPath) throws IOException {
        int[] ords = new int[categoryPath.length];
        for (int i = 0; i < categoryPath.length; ++i) {
            ords[i] = this.getOrdinal(categoryPath[i]);
        }
        return ords;
    }

    public int getOrdinal(String dim, String ... path) throws IOException {
        String[] fullPath = new String[path.length + 1];
        fullPath[0] = dim;
        System.arraycopy(path, 0, fullPath, 1, path.length);
        return this.getOrdinal(new FacetLabel(fullPath));
    }

    public abstract FacetLabel getPath(int var1) throws IOException;

    public FacetLabel[] getBulkPath(int ... ordinals) throws IOException {
        FacetLabel[] facetLabels = new FacetLabel[ordinals.length];
        for (int i = 0; i < ordinals.length; ++i) {
            facetLabels[i] = this.getPath(ordinals[i]);
        }
        return facetLabels;
    }

    public final int getRefCount() {
        return this.refCount.get();
    }

    public abstract int getSize();

    public final void incRef() {
        this.ensureOpen();
        this.refCount.incrementAndGet();
    }

    public final boolean tryIncRef() {
        int count;
        while ((count = this.refCount.get()) > 0) {
            if (!this.refCount.compareAndSet(count, count + 1)) continue;
            return true;
        }
        return false;
    }

    public static class ChildrenIterator {
        private final int[] siblings;
        private int child;

        ChildrenIterator(int child, int[] siblings) {
            this.siblings = siblings;
            this.child = child;
        }

        public int next() {
            int res = this.child;
            if (this.child != -1) {
                this.child = this.siblings[this.child];
            }
            return res;
        }
    }
}

