/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.ejb.cache.timer.IntervalTimerMetaDataEntry;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;

public class IntervalTimerMetaDataEntryMarshaller
implements ProtoStreamMarshaller<IntervalTimerMetaDataEntry<Object>> {
    private static final int INFO_INDEX = 1;
    private static final int START_INDEX = 2;
    private static final int LAST_TIMEOUT_INDEX = 3;
    private static final int INTERVAL_INDEX = 4;
    private static final Instant DEFAULT_START = Instant.EPOCH;

    public Class<? extends IntervalTimerMetaDataEntry<Object>> getJavaClass() {
        return IntervalTimerMetaDataEntry.class;
    }

    public IntervalTimerMetaDataEntry<Object> readFrom(ProtoStreamReader reader) throws IOException {
        MarshalledValue context = null;
        Instant start = DEFAULT_START;
        Duration lastTimeout = null;
        Duration interval = null;
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    context = (MarshalledValue)reader.readObject(ByteBufferMarshalledValue.class);
                    continue block6;
                }
                case 2: {
                    start = (Instant)reader.readObject(Instant.class);
                    continue block6;
                }
                case 3: {
                    lastTimeout = (Duration)reader.readObject(Duration.class);
                    continue block6;
                }
                case 4: {
                    interval = (Duration)reader.readObject(Duration.class);
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        IntervalTimerMetaDataEntry<Object> entry = new IntervalTimerMetaDataEntry<Object>(context, start, interval);
        entry.setLastTimeout(lastTimeout);
        return entry;
    }

    public void writeTo(ProtoStreamWriter writer, IntervalTimerMetaDataEntry<Object> entry) throws IOException {
        Duration interval;
        Duration lastTimeout;
        Instant start;
        Object context = entry.getContext();
        if (context != null) {
            writer.writeObject(1, context);
        }
        if (!(start = entry.getStart()).equals(DEFAULT_START)) {
            writer.writeObject(2, (Object)start);
        }
        if ((lastTimeout = entry.getLastTimeout()) != null) {
            writer.writeObject(3, (Object)lastTimeout);
        }
        if ((interval = entry.getInterval()) != null) {
            writer.writeObject(4, (Object)interval);
        }
    }
}

