/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class LongType
extends AbstractPrimitiveType<Long> {
    private LongEncoding _longEncoding;
    private LongEncoding _smallLongEncoding;

    LongType(EncoderImpl encoder, DecoderImpl decoder) {
        this._longEncoding = new AllLongEncoding(encoder, decoder);
        this._smallLongEncoding = new SmallLongEncoding(encoder, decoder);
        encoder.register(Long.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Long> getTypeClass() {
        return Long.class;
    }

    public LongEncoding getEncoding(Long val) {
        return this.getEncoding((long)val);
    }

    public LongEncoding getEncoding(long l) {
        return l >= -128L && l <= 127L ? this._smallLongEncoding : this._longEncoding;
    }

    @Override
    public LongEncoding getCanonicalEncoding() {
        return this._longEncoding;
    }

    @Override
    public Collection<LongEncoding> getAllEncodings() {
        return Arrays.asList(this._smallLongEncoding, this._longEncoding);
    }

    @Override
    public void write(long l) {
        if (l >= -128L && l <= 127L) {
            this._smallLongEncoding.write(l);
        } else {
            this._longEncoding.write(l);
        }
    }

    private class SmallLongEncoding
    extends FixedSizePrimitiveTypeEncoding<Long>
    implements LongEncoding {
        public SmallLongEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public byte getEncodingCode() {
            return 85;
        }

        @Override
        protected int getFixedSize() {
            return 1;
        }

        @Override
        public void write(long l) {
            this.writeConstructor();
            this.getEncoder().writeRaw((byte)l);
        }

        @Override
        public void writeValue(long l) {
            this.getEncoder().writeRaw((byte)l);
        }

        @Override
        public long readPrimitiveValue() {
            return this.getDecoder().readRawByte();
        }

        @Override
        public LongType getType() {
            return LongType.this;
        }

        @Override
        public void writeValue(Long val) {
            this.getEncoder().writeRaw((byte)val.longValue());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Long> encoder) {
            return encoder == this;
        }

        @Override
        public Long readValue() {
            return this.readPrimitiveValue();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    private class AllLongEncoding
    extends FixedSizePrimitiveTypeEncoding<Long>
    implements LongEncoding {
        public AllLongEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 8;
        }

        @Override
        public byte getEncodingCode() {
            return -127;
        }

        @Override
        public LongType getType() {
            return LongType.this;
        }

        @Override
        public void writeValue(Long val) {
            this.getEncoder().writeRaw(val);
        }

        @Override
        public void write(long l) {
            this.writeConstructor();
            this.getEncoder().writeRaw(l);
        }

        @Override
        public void writeValue(long l) {
            this.getEncoder().writeRaw(l);
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Long> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Long readValue() {
            return this.readPrimitiveValue();
        }

        @Override
        public long readPrimitiveValue() {
            return this.getDecoder().readRawLong();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    public static interface LongEncoding
    extends PrimitiveTypeEncoding<Long> {
        public void write(long var1);

        @Override
        public void writeValue(long var1);

        public long readPrimitiveValue();
    }
}

