/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import java.util.function.Predicate;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;

public class SecurityDomainResolvingProcessor
implements DeploymentUnitProcessor {
    private static final String JAAS_CONTEXT_ROOT = "java:jboss/jaas/";
    private static final String JASPI_CONTEXT_ROOT = "java:jboss/jbsx/";
    private static final String LEGACY_JAAS_CONTEXT_ROOT = "java:/jaas/";
    private final String defaultSecurityDomain;
    private final Predicate<String> mappedSecurityDomain;

    public SecurityDomainResolvingProcessor(String defaultSecurityDomain, Predicate<String> mappedSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
        this.mappedSecurityDomain = mappedSecurityDomain;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        SecurityMetaData securityMetaData = (SecurityMetaData)deploymentUnit.getAttachment(SecurityMetaData.ATTACHMENT_KEY);
        if (securityMetaData != null && securityMetaData.getSecurityDomain() != null) {
            return;
        }
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        String securityDomain = metaData.getSecurityDomain();
        if (securityDomain == null) {
            securityDomain = SecurityDomainResolvingProcessor.getJBossAppSecurityDomain(deploymentUnit);
        }
        String string = securityDomain = securityDomain == null ? this.defaultSecurityDomain : SecurityDomainResolvingProcessor.unprefixSecurityDomain(securityDomain);
        if (securityDomain != null && this.mappedSecurityDomain.test(securityDomain)) {
            ServiceName securityDomainName = ((CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT)).getCapabilityServiceName("org.wildfly.undertow.application-security-domain", new String[]{securityDomain}).append(new String[]{"security-domain"});
            if (securityMetaData != null) {
                securityMetaData.setSecurityDomain(securityDomainName);
            }
            deploymentUnit.putAttachment(UndertowAttachments.RESOLVED_SECURITY_DOMAIN, (Object)securityDomain);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(UndertowAttachments.RESOLVED_SECURITY_DOMAIN);
    }

    private static String getJBossAppSecurityDomain(DeploymentUnit deploymentUnit) {
        EarMetaData jbossAppMetaData;
        String securityDomain = null;
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent != null && (jbossAppMetaData = (EarMetaData)parent.getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA)) instanceof JBossAppMetaData) {
            securityDomain = ((JBossAppMetaData)jbossAppMetaData).getSecurityDomain();
        }
        return securityDomain != null ? securityDomain.trim() : null;
    }

    public static String unprefixSecurityDomain(String securityDomain) {
        String result = null;
        if (securityDomain != null) {
            result = securityDomain.startsWith(JAAS_CONTEXT_ROOT) ? securityDomain.substring(JAAS_CONTEXT_ROOT.length()) : (securityDomain.startsWith(JASPI_CONTEXT_ROOT) ? securityDomain.substring(JASPI_CONTEXT_ROOT.length()) : (securityDomain.startsWith(LEGACY_JAAS_CONTEXT_ROOT) ? securityDomain.substring(LEGACY_JAAS_CONTEXT_ROOT.length()) : securityDomain));
        }
        return result;
    }
}

