/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricFunction;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.OperationFunction;
import org.jboss.as.clustering.controller.OperationHandler;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.ModClusterBalancerDefinition;
import org.wildfly.extension.undertow.filters.ModClusterContextDefinition;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.ModClusterServiceNameProvider;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class ModClusterNodeDefinition
extends SimpleResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"node");
    static final ResourceDescriptionResolver RESOLVER = UndertowExtension.getResolver("filter", ModClusterDefinition.PATH_ELEMENT.getKey(), ModClusterBalancerDefinition.PATH_ELEMENT.getKey(), PATH_ELEMENT.getKey());
    static final BiFunction<String, ModelType, PrimitiveListAttributeDefinition.Builder> PRIMITIVE_LIST_BUILDER_FACTORY = PrimitiveListAttributeDefinition.Builder::new;
    private final FunctionExecutorRegistry<ModCluster> registry;
    static final Function<OperationContext, Function<ModCluster, ModClusterStatus.Node>> NODE_FUNCTION_FACTORY = new Function<OperationContext, Function<ModCluster, ModClusterStatus.Node>>(){

        @Override
        public Function<ModCluster, ModClusterStatus.Node> apply(OperationContext context) {
            PathAddress nodeAddress = context.getCurrentAddress();
            String nodeName = nodeAddress.getLastElement().getValue();
            PathAddress balancerAddress = nodeAddress.getParent();
            String balancerName = balancerAddress.getLastElement().getValue();
            return new NodeFunction(balancerName, nodeName);
        }
    };

    ModClusterNodeDefinition(FunctionExecutorRegistry<ModCluster> registry) {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, RESOLVER).setRuntime());
        this.registry = registry;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new ModClusterContextDefinition(this.registry));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        new OperationHandler((OperationExecutor)new NodeOperationExecutor(new FunctionExecutorFactory(this.registry)), NodeOperation.class).register(resourceRegistration);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        MetricHandler handler = new MetricHandler((MetricExecutor)new NodeMetricExecutor(new FunctionExecutorFactory(this.registry)), NodeMetric.class);
        for (NodeMetric metric : EnumSet.allOf(NodeMetric.class)) {
            resourceRegistration.registerReadOnlyAttribute(metric.getDefinition(), (OperationStepHandler)handler);
        }
    }

    static class NodeOperationExecutor
    implements OperationExecutor<ModClusterStatus.Node> {
        private final Function<OperationContext, FunctionExecutor<ModCluster>> factory;

        NodeOperationExecutor(Function<OperationContext, FunctionExecutor<ModCluster>> factory) {
            this.factory = factory;
        }

        public ModelNode execute(OperationContext context, ModelNode op, Operation<ModClusterStatus.Node> operation) throws OperationFailedException {
            FunctionExecutor<ModCluster> executor = this.factory.apply(context);
            Function<ModCluster, ModClusterStatus.Node> mapper = NODE_FUNCTION_FACTORY.apply(context);
            return executor != null ? (ModelNode)executor.execute((ExceptionFunction)new OperationFunction((ExpressionResolver)context, op, mapper, operation)) : null;
        }
    }

    static class FunctionExecutorFactory
    implements Function<OperationContext, FunctionExecutor<ModCluster>> {
        private final FunctionExecutorRegistry<ModCluster> registry;

        FunctionExecutorFactory(FunctionExecutorRegistry<ModCluster> registry) {
            this.registry = registry;
        }

        @Override
        public FunctionExecutor<ModCluster> apply(OperationContext context) {
            PathAddress serviceAddress = context.getCurrentAddress().getParent().getParent();
            return this.registry.getExecutor((Object)ServiceDependency.on((ServiceName)new ModClusterServiceNameProvider(serviceAddress).getServiceName()));
        }
    }

    static enum NodeOperation implements Operation<ModClusterStatus.Node>
    {
        ENABLE("enable", ModClusterStatus.Context::enable),
        DISABLE("disable", ModClusterStatus.Context::disable),
        STOP("stop", ModClusterStatus.Context::stop);

        private OperationDefinition definition;
        private final Consumer<ModClusterStatus.Context> operation;

        private NodeOperation(String name, Consumer<ModClusterStatus.Context> operation) {
            this.definition = SimpleOperationDefinitionBuilder.of((String)name, (ResourceDescriptionResolver)RESOLVER).setRuntimeOnly().build();
            this.operation = operation;
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterStatus.Node node) {
            node.getContexts().forEach(this.operation);
            return null;
        }

        public OperationDefinition getDefinition() {
            return this.definition;
        }
    }

    static class NodeMetricExecutor
    implements MetricExecutor<ModClusterStatus.Node> {
        private final Function<OperationContext, FunctionExecutor<ModCluster>> factory;

        NodeMetricExecutor(Function<OperationContext, FunctionExecutor<ModCluster>> factory) {
            this.factory = factory;
        }

        public ModelNode execute(OperationContext context, Metric<ModClusterStatus.Node> metric) throws OperationFailedException {
            FunctionExecutor<ModCluster> executor = this.factory.apply(context);
            Function<ModCluster, ModClusterStatus.Node> mapper = NODE_FUNCTION_FACTORY.apply(context);
            return executor != null ? (ModelNode)executor.execute((ExceptionFunction)new MetricFunction(mapper, metric)) : null;
        }
    }

    static enum NodeMetric implements Metric<ModClusterStatus.Node>
    {
        LOAD("load", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getLoad());
            }
        }
        ,
        STATUS("status", ModelType.STRING){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getStatus().name());
            }
        }
        ,
        LOAD_BALANCING_GROUP("load-balancing-group", ModelType.STRING){

            public ModelNode execute(ModClusterStatus.Node node) {
                return Optional.ofNullable(node.getDomain()).map(ModelNode::new).orElse(null);
            }
        }
        ,
        CACHE_CONNECTIONS("cache-connections", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getCacheConnections());
            }
        }
        ,
        MAX_CONNECTIONS("max-connections", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getMaxConnections());
            }
        }
        ,
        OPEN_CONNECTIONS("open-connections", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getOpenConnections());
            }
        }
        ,
        PING("ping", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getPing());
            }
        }
        ,
        READ("read", ModelType.LONG){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getRead());
            }

            @Override
            <D extends AttributeDefinition, B extends AbstractAttributeDefinitionBuilder<B, D>> B configure(B builder) {
                return (B)builder.setMeasurementUnit(MeasurementUnit.BYTES);
            }
        }
        ,
        REQUEST_QUEUE_SIZE("request-queue-size", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getRequestQueueSize());
            }
        }
        ,
        TIMEOUT("timeout", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getTimeout());
            }

            @Override
            <D extends AttributeDefinition, B extends AbstractAttributeDefinitionBuilder<B, D>> B configure(B builder) {
                return (B)builder.setMeasurementUnit(MeasurementUnit.SECONDS);
            }
        }
        ,
        WRITTEN("written", ModelType.LONG){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getTransferred());
            }

            @Override
            <D extends AttributeDefinition, B extends AbstractAttributeDefinitionBuilder<B, D>> B configure(B builder) {
                return (B)builder.setMeasurementUnit(MeasurementUnit.BYTES);
            }
        }
        ,
        TTL("ttl", ModelType.LONG){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getTtl());
            }
        }
        ,
        FLUSH_PACKETS("flush-packets", ModelType.BOOLEAN){

            public ModelNode execute(ModClusterStatus.Node node) {
                return node.isFlushPackets() ? ModelNode.TRUE : ModelNode.FALSE;
            }
        }
        ,
        QUEUE_NEW_REQUESTS("queue-new-requests", ModelType.BOOLEAN){

            public ModelNode execute(ModClusterStatus.Node node) {
                return node.isQueueNewRequests() ? ModelNode.TRUE : ModelNode.FALSE;
            }
        }
        ,
        URI("uri", ModelType.STRING){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getUri().toString());
            }
        }
        ,
        ALIASES("aliases", ModelType.STRING, PRIMITIVE_LIST_BUILDER_FACTORY){

            public ModelNode execute(ModClusterStatus.Node node) {
                ModelNode result = new ModelNode();
                for (String alias : node.getAliases()) {
                    result.add(alias);
                }
                return result;
            }
        }
        ,
        ELECTED("elected", ModelType.INT){

            public ModelNode execute(ModClusterStatus.Node node) {
                return new ModelNode(node.getElected());
            }
        };

        private final AttributeDefinition definition;

        private NodeMetric(String name, ModelType type) {
            this(name, type, SimpleAttributeDefinitionBuilder::new);
        }

        private <D extends AttributeDefinition, B extends AbstractAttributeDefinitionBuilder<B, D>> NodeMetric(String name, ModelType type, BiFunction<String, ModelType, B> builderFactory) {
            this.definition = this.configure((AbstractAttributeDefinitionBuilder)builderFactory.apply(name, type)).setRequired(false).setStorageRuntime().build();
        }

        <D extends AttributeDefinition, B extends AbstractAttributeDefinitionBuilder<B, D>> B configure(B builder) {
            return builder;
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static class NodeFunction
    implements Function<ModCluster, ModClusterStatus.Node> {
        private final String balancerName;
        private final String nodeName;

        NodeFunction(String balancerName, String nodeName) {
            this.balancerName = balancerName;
            this.nodeName = nodeName;
        }

        @Override
        public ModClusterStatus.Node apply(ModCluster service) {
            ModClusterStatus.LoadBalancer balancer = service.getController().getStatus().getLoadBalancer(this.balancerName);
            return balancer != null ? balancer.getNode(this.nodeName) : null;
        }
    }
}

