/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MappingAnnotatedMethodParameter;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MethodParameterMappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl.AbstractMappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.util.common.reflect.spi.AnnotationHelper;
import org.hibernate.search.util.common.reporting.EventContext;

public class MethodParameterMappingAnnotationProcessorContextImpl
extends AbstractMappingAnnotationProcessorContext
implements MethodParameterMappingAnnotationProcessorContext,
MappingAnnotatedMethodParameter {
    private final PojoConstructorModel<?> constructorModel;
    private final PojoMethodParameterModel<?> methodParameterModel;
    private final Annotation annotation;

    public MethodParameterMappingAnnotationProcessorContextImpl(PojoConstructorModel<?> constructorModel, PojoMethodParameterModel<?> methodParameterModel, Annotation annotation, AnnotationHelper annotationHelper) {
        super(annotationHelper);
        this.constructorModel = constructorModel;
        this.methodParameterModel = methodParameterModel;
        this.annotation = annotation;
    }

    @Override
    public MappingAnnotatedMethodParameter annotatedElement() {
        return this;
    }

    @Override
    public EventContext eventContext() {
        return PojoEventContexts.fromType(this.constructorModel.typeModel()).append(PojoEventContexts.fromConstructor(this.constructorModel)).append(PojoEventContexts.fromMethodParameter(this.methodParameterModel)).append(PojoEventContexts.fromAnnotation(this.annotation));
    }

    @Override
    public Optional<String> name() {
        return this.methodParameterModel.name();
    }

    @Override
    public Class<?> javaClass() {
        return this.methodParameterModel.typeModel().rawType().typeIdentifier().javaClass();
    }

    @Override
    public Stream<Annotation> allAnnotations() {
        return this.methodParameterModel.annotations().flatMap(arg_0 -> ((AnnotationHelper)this.annotationHelper).expandRepeatableContainingAnnotation(arg_0));
    }
}

