/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.access.management.ManagementSecurityIdentitySupplier;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.server.BootstrapImpl;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.git.GitConfigurationPersister;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.threads.AsyncFuture;

public interface Bootstrap {
    public AsyncFuture<ServiceContainer> bootstrap(Configuration var1, List<ServiceActivator> var2);

    public AsyncFuture<ServiceContainer> startup(Configuration var1, List<ServiceActivator> var2);

    public void failed();

    public static final class Factory {
        private Factory() {
        }

        public static Bootstrap newInstance() {
            return new BootstrapImpl();
        }
    }

    public static interface ConfigurationPersisterFactory {
        public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment var1, ExecutorService var2);
    }

    public static final class Configuration {
        private final ServerEnvironment serverEnvironment;
        private final RunningModeControl runningModeControl;
        private final ExtensionRegistry extensionRegistry;
        private final CapabilityRegistry capabilityRegistry;
        private final ManagedAuditLogger auditLogger;
        private final DelegatingConfigurableAuthorizer authorizer;
        private final ManagementSecurityIdentitySupplier securityIdentitySupplier;
        private ModuleLoader moduleLoader = Module.getBootModuleLoader();
        private ConfigurationPersisterFactory configurationPersisterFactory;

        public Configuration(ServerEnvironment serverEnvironment) {
            assert (serverEnvironment != null) : "serverEnvironment is null";
            this.serverEnvironment = serverEnvironment;
            this.runningModeControl = serverEnvironment.getRunningModeControl();
            this.auditLogger = serverEnvironment.createAuditLogger();
            this.authorizer = new DelegatingConfigurableAuthorizer();
            this.securityIdentitySupplier = new ManagementSecurityIdentitySupplier();
            this.extensionRegistry = ExtensionRegistry.builder((ProcessType)serverEnvironment.getLaunchType().getProcessType()).withRunningModeControl(this.runningModeControl).withStabilitySupplier(serverEnvironment::getStability).withAuditLogger(this.auditLogger).withAuthorizer((JmxAuthorizer)this.authorizer).withSecurityIdentitySupplier((Supplier)this.securityIdentitySupplier).build();
            this.capabilityRegistry = new CapabilityRegistry(true);
        }

        public ServerEnvironment getServerEnvironment() {
            return this.serverEnvironment;
        }

        RunningModeControl getRunningModeControl() {
            return this.runningModeControl;
        }

        public ExtensionRegistry getExtensionRegistry() {
            return this.extensionRegistry;
        }

        public CapabilityRegistry getCapabilityRegistry() {
            return this.capabilityRegistry;
        }

        public ManagedAuditLogger getAuditLogger() {
            return this.auditLogger;
        }

        public DelegatingConfigurableAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        public ManagementSecurityIdentitySupplier getSecurityIdentitySupplier() {
            return this.securityIdentitySupplier;
        }

        public ModuleLoader getModuleLoader() {
            return this.moduleLoader;
        }

        public void setModuleLoader(ModuleLoader moduleLoader) {
            assert (moduleLoader != null) : "moduleLoader is null";
            this.moduleLoader = moduleLoader;
        }

        public synchronized ConfigurationPersisterFactory getConfigurationPersisterFactory() {
            if (this.configurationPersisterFactory == null) {
                this.configurationPersisterFactory = new ConfigurationPersisterFactory(){

                    @Override
                    public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                        ConfigurationFile configurationFile = serverEnvironment.getServerConfigurationFile();
                        if (runningModeControl.isReloaded()) {
                            configurationFile.resetBootFile(runningModeControl.isUseCurrentConfig(), runningModeControl.getAndClearNewBootFileName());
                        }
                        QName rootElement = new QName(Namespace.CURRENT.getUriString(), "server");
                        StandaloneXml parser = new StandaloneXml(Module.getBootModuleLoader(), executorService, extensionRegistry);
                        GitConfigurationPersister persister = configurationFile.useGit() ? new GitConfigurationPersister(serverEnvironment.getGitRepository(), configurationFile, rootElement, parser, parser, runningModeControl.isReloaded()) : new BackupXmlConfigurationPersister(configurationFile, rootElement, (XMLElementReader)parser, (XMLElementWriter)parser, runningModeControl.isReloaded(), serverEnvironment.getLaunchType() == ServerEnvironment.LaunchType.EMBEDDED);
                        for (Namespace namespace : Namespace.domainValues()) {
                            if (namespace.equals((Object)Namespace.CURRENT)) continue;
                            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "server"), parser);
                        }
                        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
                        return persister;
                    }
                };
            }
            return this.configurationPersisterFactory;
        }

        public synchronized void setConfigurationPersisterFactory(ConfigurationPersisterFactory configurationPersisterFactory) {
            this.configurationPersisterFactory = configurationPersisterFactory;
        }

        @Deprecated(forRemoval=true)
        public long getStartTime() {
            return this.serverEnvironment.getStartTime();
        }
    }
}

