/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitPhaseBuilder;
import org.jboss.as.server.deployment.DeploymentUnitPhaseService;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.msc.service.DelegatingServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public abstract class AbstractDeploymentUnitService
implements Service<DeploymentUnit> {
    private static final String FIRST_PHASE_NAME = Phase.values()[0].name();
    final ImmutableManagementResourceRegistration registration;
    final ManagementResourceRegistration mutableRegistration;
    final Resource resource;
    final CapabilityServiceSupport capabilityServiceSupport;
    private final Consumer<DeploymentUnit> deploymentUnitConsumer;
    protected final String name;
    private volatile UnaryOperator<ServiceTarget> serviceTargetTransformer = null;
    private volatile DeploymentUnit deploymentUnit;
    private volatile StabilityMonitor monitor;

    AbstractDeploymentUnitService(Consumer<DeploymentUnit> deploymentUnitConsumer, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, Resource resource, CapabilityServiceSupport capabilityServiceSupport, String name) {
        this.deploymentUnitConsumer = deploymentUnitConsumer;
        this.mutableRegistration = mutableRegistration;
        this.capabilityServiceSupport = capabilityServiceSupport;
        this.registration = registration;
        this.resource = resource;
        this.name = name;
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceTarget target = context.getChildTarget();
        this.monitor = new StabilityMonitor();
        this.monitor.addController(context.getController());
        this.deploymentUnit = this.createAndInitializeDeploymentUnit((ServiceRegistry)context.getController().getServiceContainer());
        String managementName = this.deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME);
        if (this.deploymentUnit.getParent() == null) {
            ServerLogger.DEPLOYMENT_LOGGER.startingDeployment(managementName, this.name);
        } else {
            ServerLogger.DEPLOYMENT_LOGGER.startingSubDeployment(this.name);
        }
        final Consumer<StartContext> installer = new Consumer<StartContext>(){

            @Override
            public void accept(StartContext context) {
                ServiceName serviceName = AbstractDeploymentUnitService.this.deploymentUnit.getServiceName().append(new String[]{FIRST_PHASE_NAME});
                DeploymentUnitPhaseService<?> phaseService = DeploymentUnitPhaseService.create(AbstractDeploymentUnitService.this.deploymentUnit, Phase.values()[0]);
                context.getChildTarget().addService(serviceName, phaseService).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector()).install();
            }
        };
        if (this.serviceTargetTransformer != null) {
            this.deploymentUnit.putAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_SERVICE_TARGET_TRANSFORMER, this.serviceTargetTransformer);
            this.deploymentUnit.putAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_BUILDER, new DeploymentUnitPhaseBuilder(){

                @Override
                public <T> ServiceBuilder<T> build(ServiceTarget target, ServiceName name, Service<T> service) {
                    return ((ServiceTarget)AbstractDeploymentUnitService.this.serviceTargetTransformer.apply(target)).addService(name, service);
                }
            });
            final Set<AttachmentKey<?>> initialAttachmentKeys = this.getDeploymentUnitAttachmentKeys();
            final Runnable uninstaller = new Runnable(){

                @Override
                public void run() {
                    for (AttachmentKey<?> key : AbstractDeploymentUnitService.this.getDeploymentUnitAttachmentKeys()) {
                        if (initialAttachmentKeys.contains(key)) continue;
                        AbstractDeploymentUnitService.this.deploymentUnit.removeAttachment(key);
                    }
                }
            };
            ((ServiceTarget)this.serviceTargetTransformer.apply(target)).addService(this.deploymentUnit.getServiceName().append(new String[]{"installer"}), (Service)new Service<Void>(){

                public void start(StartContext context) throws StartException {
                    installer.accept(context);
                }

                public void stop(StopContext context) {
                    uninstaller.run();
                }

                public Void getValue() {
                    return null;
                }
            }).install();
        } else {
            installer.accept(context);
        }
        this.deploymentUnitConsumer.accept(this.deploymentUnit);
    }

    protected abstract DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry var1);

    public synchronized void stop(StopContext context) {
        DeploymentUnitPhaseBuilder builder;
        this.deploymentUnitConsumer.accept(null);
        String managementName = this.deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME);
        if (this.deploymentUnit.getParent() == null) {
            ServerLogger.DEPLOYMENT_LOGGER.stoppedDeployment(managementName, this.name, (int)(context.getElapsedTime() / 1000000L));
        } else {
            ServerLogger.DEPLOYMENT_LOGGER.stoppedSubDeployment(this.name, (int)(context.getElapsedTime() / 1000000L));
        }
        this.serviceTargetTransformer = this.deploymentUnit.getAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_SERVICE_TARGET_TRANSFORMER);
        if (this.serviceTargetTransformer == null && (builder = this.deploymentUnit.getAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_BUILDER)) != null) {
            this.serviceTargetTransformer = new UnaryOperator<ServiceTarget>(){

                @Override
                public ServiceTarget apply(final ServiceTarget target) {
                    return new DelegatingServiceTarget(target){

                        public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) {
                            return builder.build(target, name, service);
                        }
                    };
                }
            };
        }
        for (AttachmentKey<?> key : this.getDeploymentUnitAttachmentKeys()) {
            this.deploymentUnit.removeAttachment(key);
        }
        this.deploymentUnit = null;
        this.monitor.removeController(context.getController());
        this.monitor = null;
        DeploymentResourceSupport.cleanup(this.resource);
    }

    private Set<AttachmentKey<?>> getDeploymentUnitAttachmentKeys() {
        return ((SimpleAttachable)((Object)this.deploymentUnit)).attachmentKeys();
    }

    public synchronized DeploymentUnit getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit;
    }

    public DeploymentStatus getStatus() {
        StabilityMonitor monitor = this.monitor;
        if (monitor == null) {
            return DeploymentStatus.STOPPED;
        }
        HashSet problems = new HashSet();
        try {
            monitor.awaitStability(problems, problems);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return problems.isEmpty() ? DeploymentStatus.OK : DeploymentStatus.FAILED;
    }

    public static enum DeploymentStatus {
        NEW,
        OK,
        FAILED,
        STOPPED;

    }
}

