/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import jakarta.jms.Queue;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.deployment.JmsDestination;
import org.wildfly.extension.messaging.activemq.deployment.MessagingAttachments;
import org.wildfly.extension.messaging.activemq.deployment.ParseResult;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicService;

public class MessagingXmlInstallDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List parseResults = deploymentUnit.getAttachmentList(MessagingAttachments.PARSE_RESULT);
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        for (ParseResult parseResult : parseResults) {
            String[] jndiBindings;
            ServiceName serverServiceName;
            for (JmsDestination topic : parseResult.getTopics()) {
                serverServiceName = MessagingServices.getActiveMQServiceName(topic.getServer());
                jndiBindings = null;
                if (topic.getDestination().hasDefined(CommonAttributes.DESTINATION_ENTRIES.getName())) {
                    ModelNode entries = topic.getDestination().resolve().get(CommonAttributes.DESTINATION_ENTRIES.getName());
                    jndiBindings = JMSServices.getJndiBindings(entries);
                }
                JMSTopicService topicService = JMSTopicService.installService(topic.getName(), serverServiceName, phaseContext.getServiceTarget());
                ServiceName topicServiceName = JMSServices.getJmsTopicBaseServiceName(serverServiceName).append(new String[]{topic.getName()});
                for (String string : jndiBindings) {
                    BinderServiceUtil.installBinderService(phaseContext.getServiceTarget(), string, topicService, topicServiceName);
                }
                PathElement serverElement = PathElement.pathElement((String)"server", (String)topic.getServer());
                PathElement destination = PathElement.pathElement((String)"jms-topic", (String)topic.getName());
                deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, destination});
                MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
                JMSTopicConfigurationRuntimeHandler.INSTANCE.registerResource(topic.getServer(), topic.getName(), topic.getDestination());
            }
            for (JmsDestination queue : parseResult.getQueues()) {
                serverServiceName = MessagingServices.getActiveMQServiceName(queue.getServer());
                jndiBindings = null;
                ModelNode destination = queue.getDestination();
                if (destination.hasDefined(CommonAttributes.DESTINATION_ENTRIES.getName())) {
                    ModelNode entries = destination.resolve().get(CommonAttributes.DESTINATION_ENTRIES.getName());
                    jndiBindings = JMSServices.getJndiBindings(entries);
                }
                String selector = destination.hasDefined(CommonAttributes.SELECTOR.getName()) ? destination.get(CommonAttributes.SELECTOR.getName()).resolve().asString() : null;
                boolean durable = destination.hasDefined(CommonAttributes.DURABLE.getName()) ? destination.get(CommonAttributes.DURABLE.getName()).resolve().asBoolean() : false;
                Service<Queue> queueService = JMSQueueService.installService(queue.getName(), phaseContext.getServiceTarget(), serverServiceName, selector, durable);
                ServiceName queueServiceName = JMSServices.getJmsQueueBaseServiceName(serverServiceName).append(new String[]{queue.getName()});
                for (String binding2 : jndiBindings) {
                    BinderServiceUtil.installBinderService(phaseContext.getServiceTarget(), binding2, queueService, queueServiceName);
                }
                PathElement pathElement = PathElement.pathElement((String)"server", (String)queue.getServer());
                PathElement dest = PathElement.pathElement((String)"jms-queue", (String)queue.getName());
                deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", pathElement);
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{pathElement, dest});
                MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
                JMSQueueConfigurationRuntimeHandler.INSTANCE.registerResource(queue.getServer(), queue.getName(), destination);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
        List parseResults = context.getAttachmentList(MessagingAttachments.PARSE_RESULT);
        for (ParseResult parseResult : parseResults) {
            for (JmsDestination topic : parseResult.getTopics()) {
                JMSTopicConfigurationRuntimeHandler.INSTANCE.unregisterResource(topic.getServer(), topic.getName());
            }
            for (JmsDestination queue : parseResult.getQueues()) {
                JMSQueueConfigurationRuntimeHandler.INSTANCE.unregisterResource(queue.getServer(), queue.getName());
            }
        }
    }

    static void createDeploymentSubModel(PathAddress address, DeploymentUnit unit) {
        ((DeploymentResourceSupport)unit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT)).getDeploymentSubModel("messaging-activemq", address);
    }
}

