/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.DomainFinalResultHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainRolloutStepHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainSlaveHandler;
import org.jboss.as.domain.controller.operations.coordination.HostControllerExecutionSupport;
import org.jboss.as.domain.controller.operations.coordination.MultiphaseOverallContext;
import org.jboss.as.domain.controller.operations.coordination.OperationRouting;
import org.jboss.as.domain.controller.operations.coordination.OperationSlaveStepHandler;
import org.jboss.as.domain.controller.operations.coordination.PrepareStepHandler;
import org.jboss.as.domain.controller.operations.coordination.SecurityActions;
import org.jboss.dmr.ModelNode;

public class OperationCoordinatorStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final Map<String, ProxyController> hostProxies;
    private final Map<String, ProxyController> serverProxies;
    private final OperationSlaveStepHandler localSlaveHandler;
    private volatile ExecutorService executorService;

    OperationCoordinatorStepHandler(LocalHostControllerInfo localHostControllerInfo, Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, OperationSlaveStepHandler localSlaveHandler) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.localSlaveHandler = localSlaveHandler;
    }

    void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        OperationRouting routing = OperationRouting.determineRouting(context, operation, this.localHostControllerInfo, this.hostProxies.keySet());
        if (!this.localHostControllerInfo.isMasterDomainController() && !routing.isLocalOnly(this.localHostControllerInfo.getLocalHostName())) {
            this.routeToMasterDomainController(context, operation);
        } else if (routing.getSingleHost() != null && !this.localHostControllerInfo.getLocalHostName().equals(routing.getSingleHost())) {
            if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.trace("Remote single host");
            }
            OperationCoordinatorStepHandler.configureDomainUUID(operation);
            if ("composite".equals(operation.get("operation").asString()) && PathAddress.pathAddress((ModelNode)operation.get("address")).size() == 0) {
                assert (!routing.isMultiphase());
                this.executeTwoPhaseOperation(context, operation, routing);
            } else {
                this.executeDirect(context, operation, false);
            }
        } else if (!routing.isMultiphase()) {
            this.executeDirect(context, operation, true);
        } else {
            assert (routing.isMultiphase());
            this.executeTwoPhaseOperation(context, operation, routing);
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private ExecutorService getExecutorService() {
        return this.executorService == null ? Executors.newSingleThreadExecutor() : this.executorService;
    }

    private void routeToMasterDomainController(OperationContext context, ModelNode operation) {
        context.getFailureDescription().set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.masterDomainControllerOnlyOperation(operation.get("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address"))));
    }

    private void executeDirect(OperationContext context, ModelNode operation, boolean checkPrivate) throws OperationFailedException {
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("%s executing direct", this.getClass().getSimpleName());
        }
        PrepareStepHandler.executeDirectOperation(context, operation, checkPrivate);
    }

    private void executeTwoPhaseOperation(OperationContext context, ModelNode operation, OperationRouting routing) throws OperationFailedException {
        DomainControllerLogger.HOST_CONTROLLER_LOGGER.trace("Executing two-phase");
        OperationCoordinatorStepHandler.configureDomainUUID(operation);
        MultiphaseOverallContext overallContext = new MultiphaseOverallContext(this.localHostControllerInfo);
        ModelNode operationHeaders = operation.get("operation-headers");
        ModelNode rolloutPlan = operationHeaders.has("rollout-plan") ? operation.get("operation-headers").remove("rollout-plan") : new ModelNode();
        ModelNode slaveOp = operation.clone();
        slaveOp.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        slaveOp.protect();
        HostControllerExecutionSupport localHCES = null;
        String localHostName = this.localHostControllerInfo.getLocalHostName();
        if (routing.isLocalCallNeeded(localHostName)) {
            localHCES = this.localSlaveHandler.addSteps(context, slaveOp.clone(), overallContext.getLocalContext());
        }
        context.addStep((OperationStepHandler)new DomainFinalResultHandler(overallContext, localHCES), OperationContext.Stage.MODEL, true);
        if (this.localHostControllerInfo.isMasterDomainController()) {
            HashSet<String> remoteHosts = new HashSet<String>(routing.getHosts());
            boolean global = remoteHosts.isEmpty();
            remoteHosts.remove(localHostName);
            if (!remoteHosts.isEmpty() || global) {
                if (routing.isMultiphase()) {
                    context.acquireControllerLock();
                }
                if (global) {
                    remoteHosts.addAll(this.hostProxies.keySet());
                }
                HashMap<String, ProxyController> remoteProxies = new HashMap<String, ProxyController>();
                for (String host : remoteHosts) {
                    ProxyController proxy = this.hostProxies.get(host);
                    if (proxy != null) {
                        remoteProxies.put(host, proxy);
                        continue;
                    }
                    if (global) continue;
                    throw DomainControllerLogger.HOST_CONTROLLER_LOGGER.invalidOperationTargetHost(host);
                }
                context.addStep(slaveOp.clone(), (OperationStepHandler)new DomainSlaveHandler(remoteProxies, overallContext), OperationContext.Stage.DOMAIN);
            }
        }
        context.addStep((OperationStepHandler)new DomainRolloutStepHandler(this.hostProxies, this.serverProxies, overallContext, rolloutPlan, operationHeaders, this.getExecutorService()), OperationContext.Stage.DOMAIN);
    }

    static void configureDomainUUID(ModelNode operation) {
        if (!operation.hasDefined("operation-headers") || !operation.get("operation-headers").hasDefined("domain-uuid")) {
            String domainUUID = UUID.randomUUID().toString();
            operation.get(new String[]{"operation-headers", "domain-uuid"}).set(domainUUID);
            AccessAuditContext accessContext = SecurityActions.currentAccessAuditContext();
            if (accessContext != null) {
                accessContext.setDomainUuid(domainUUID);
            }
        }
    }
}

