/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.DomainControllerData;
import org.jboss.as.host.controller.discovery.DomainControllerManagementInterface;
import org.jboss.as.host.controller.discovery.RemoteDomainControllerConnectionConfiguration;
import org.jboss.as.host.controller.discovery.S3Util;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.remoting.Protocol;
import org.jboss.dmr.ModelNode;

public class S3Discovery
implements DiscoveryOption {
    private static final String DC_FILE_NAME = "jboss-domain-primary-data";
    private String access_key = null;
    private String secret_access_key = null;
    private String location = null;
    private String prefix = null;
    private String pre_signed_put_url = null;
    private String pre_signed_delete_url = null;
    private S3Util.AWSAuthConnection conn = null;

    public S3Discovery(Map<String, ModelNode> properties) {
        ModelNode accessKeyNode = properties.get("access-key");
        this.access_key = accessKeyNode == null || !accessKeyNode.isDefined() ? null : accessKeyNode.asString();
        ModelNode secretAccessKeyNode = properties.get("secret-access-key");
        this.secret_access_key = secretAccessKeyNode == null || !secretAccessKeyNode.isDefined() ? null : secretAccessKeyNode.asString();
        ModelNode locationNode = properties.get("location");
        this.location = locationNode == null || !locationNode.isDefined() ? null : locationNode.asString();
        ModelNode prefixNode = properties.get("prefix");
        this.prefix = prefixNode == null || !prefixNode.isDefined() ? null : prefixNode.asString();
        ModelNode preSignedPutUrlNode = properties.get("pre-signed-put-url");
        this.pre_signed_put_url = preSignedPutUrlNode == null || !preSignedPutUrlNode.isDefined() ? null : preSignedPutUrlNode.asString();
        ModelNode preSignedDeleteUrlNode = properties.get("pre-signed-delete-url");
        this.pre_signed_delete_url = preSignedDeleteUrlNode == null || !preSignedDeleteUrlNode.isDefined() ? null : preSignedDeleteUrlNode.asString();
    }

    @Override
    public void allowDiscovery(List<DomainControllerManagementInterface> interfaces) {
        try {
            ArrayList<DomainControllerData> data = new ArrayList<DomainControllerData>(interfaces.size());
            for (DomainControllerManagementInterface managementInterface : interfaces) {
                data.add(new DomainControllerData(managementInterface.getProtocol().toString(), managementInterface.getHost(), managementInterface.getPort()));
            }
            Collections.sort(data, new Comparator<DomainControllerData>(){

                @Override
                public int compare(DomainControllerData data, DomainControllerData otherData) {
                    Protocol protocol = Protocol.forName((String)data.getProtocol());
                    if (Protocol.REMOTE == protocol) {
                        return 1;
                    }
                    if (Protocol.HTTPS_REMOTING == protocol || Protocol.REMOTE_HTTPS == protocol) {
                        Protocol otherProtocol = Protocol.forName((String)otherData.getProtocol());
                        if (Protocol.REMOTE == otherProtocol) {
                            return -1;
                        }
                        return 1;
                    }
                    return -1;
                }
            });
            this.writeToFile(data, "primary");
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.cannotWriteDomainControllerData(e);
        }
    }

    @Override
    public List<RemoteDomainControllerConnectionConfiguration> discover() {
        List<DomainControllerData> dataDc = this.readFromFile("primary");
        ArrayList<RemoteDomainControllerConnectionConfiguration> options = new ArrayList<RemoteDomainControllerConnectionConfiguration>(dataDc.size());
        for (DomainControllerData data : dataDc) {
            if (data != null) {
                RemoteDomainControllerConnectionConfiguration discovery = new RemoteDomainControllerConnectionConfiguration(data.getProtocol(), data.getHost(), data.getPort());
                String host = data.getHost();
                try {
                    StaticDiscoveryResourceDefinition.HOST.getValidator().validateParameter(StaticDiscoveryResourceDefinition.HOST.getName(), host == null ? new ModelNode() : new ModelNode(host));
                    StaticDiscoveryResourceDefinition.PORT.getValidator().validateParameter(StaticDiscoveryResourceDefinition.PORT.getName(), new ModelNode(discovery.getPort()));
                    StaticDiscoveryResourceDefinition.PROTOCOL.getValidator().validateParameter(StaticDiscoveryResourceDefinition.PROTOCOL.getName(), new ModelNode(discovery.getProtocol()));
                    options.add(discovery);
                }
                catch (OperationFailedException operationFailedException) {}
                continue;
            }
            throw HostControllerLogger.ROOT_LOGGER.failedMarshallingDomainControllerData();
        }
        if (options.isEmpty()) {
            throw HostControllerLogger.ROOT_LOGGER.failedMarshallingDomainControllerData();
        }
        return options;
    }

    @Override
    public void cleanUp() {
        this.remove("primary");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private boolean usingPreSignedUrls() {
        return this.pre_signed_put_url != null;
    }

    private void validatePreSignedUrls() {
        if (this.pre_signed_put_url != null && this.pre_signed_delete_url != null) {
            S3Util.PreSignedUrlParser parsedPut = new S3Util.PreSignedUrlParser(this.pre_signed_put_url);
            S3Util.PreSignedUrlParser parsedDelete = new S3Util.PreSignedUrlParser(this.pre_signed_delete_url);
            if (!parsedPut.getBucket().equals(parsedDelete.getBucket()) || !parsedPut.getPrefix().equals(parsedDelete.getPrefix())) {
                throw HostControllerLogger.ROOT_LOGGER.preSignedUrlsMustHaveSamePath();
            }
        } else if (this.pre_signed_put_url != null || this.pre_signed_delete_url != null) {
            throw HostControllerLogger.ROOT_LOGGER.preSignedUrlsMustBeSetOrUnset();
        }
    }

    private void init() {
        this.validatePreSignedUrls();
        try {
            this.conn = new S3Util.AWSAuthConnection(this.access_key, this.secret_access_key);
            if (this.prefix != null && this.prefix.length() > 0) {
                S3Util.ListAllMyBucketsResponse bucket_list = this.conn.listAllMyBuckets(null);
                List buckets = bucket_list.entries;
                if (buckets != null) {
                    boolean found = false;
                    for (Object tmp : buckets) {
                        if (!(tmp instanceof S3Util.Bucket)) continue;
                        S3Util.Bucket bucket = (S3Util.Bucket)tmp;
                        if (!bucket.name.startsWith(this.prefix)) continue;
                        this.location = bucket.name;
                        found = true;
                    }
                    if (!found) {
                        this.location = this.prefix + "-" + UUID.randomUUID().toString();
                    }
                }
            }
            if (this.usingPreSignedUrls()) {
                S3Util.PreSignedUrlParser parsedPut = new S3Util.PreSignedUrlParser(this.pre_signed_put_url);
                this.location = parsedPut.getBucket();
            }
            if (!this.conn.checkBucketExists(this.location)) {
                this.conn.createBucket((String)this.location, (String)S3Util.AWSAuthConnection.LOCATION_DEFAULT, null).connection.getResponseMessage();
            }
        }
        catch (Exception e) {
            throw HostControllerLogger.ROOT_LOGGER.cannotAccessS3Bucket(this.location, e.getLocalizedMessage());
        }
    }

    private List<DomainControllerData> readFromFile(String directoryName) {
        List<DomainControllerData> data = new ArrayList<DomainControllerData>();
        if (directoryName == null) {
            return data;
        }
        if (this.conn == null) {
            this.init();
        }
        try {
            byte[] buf;
            if (this.usingPreSignedUrls()) {
                S3Util.PreSignedUrlParser parsedPut = new S3Util.PreSignedUrlParser(this.pre_signed_put_url);
                directoryName = parsedPut.getPrefix();
            }
            String key = S3Util.sanitize(directoryName) + "/" + S3Util.sanitize(DC_FILE_NAME);
            S3Util.GetResponse val = this.conn.get(this.location, key, null);
            if (val.object != null && (buf = val.object.data) != null && buf.length > 0) {
                try {
                    data = S3Util.domainControllerDataFromByteBuffer(buf);
                }
                catch (Exception e) {
                    throw HostControllerLogger.ROOT_LOGGER.failedMarshallingDomainControllerData();
                }
            }
            return data;
        }
        catch (IOException e) {
            throw HostControllerLogger.ROOT_LOGGER.cannotAccessS3File(e.getLocalizedMessage());
        }
    }

    private void writeToFile(List<DomainControllerData> data, String domainName) throws IOException {
        if (domainName == null || data == null) {
            return;
        }
        if (this.conn == null) {
            this.init();
        }
        try {
            String key = S3Util.sanitize(domainName) + "/" + S3Util.sanitize(DC_FILE_NAME);
            byte[] buf = S3Util.domainControllerDataToByteBuffer(data);
            S3Util.S3Object val = new S3Util.S3Object(buf, null);
            if (this.usingPreSignedUrls()) {
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
                headers.put("x-amz-acl", Arrays.asList("public-read"));
                this.conn.put((String)this.pre_signed_put_url, (S3Util.S3Object)val, headers).connection.getResponseMessage();
            } else {
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
                headers.put("Content-Type", Arrays.asList("text/plain"));
                this.conn.put((String)this.location, (String)key, (S3Util.S3Object)val, headers).connection.getResponseMessage();
            }
        }
        catch (Exception e) {
            throw HostControllerLogger.ROOT_LOGGER.cannotWriteToS3File(e.getLocalizedMessage());
        }
    }

    private void remove(String directoryName) {
        if (directoryName == null || this.conn == null) {
            return;
        }
        String key = S3Util.sanitize(directoryName) + "/" + S3Util.sanitize(DC_FILE_NAME);
        try {
            TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
            headers.put("Content-Type", Arrays.asList("text/plain"));
            if (this.usingPreSignedUrls()) {
                this.conn.delete((String)this.pre_signed_delete_url).connection.getResponseMessage();
            } else {
                this.conn.delete((String)this.location, (String)key, headers).connection.getResponseMessage();
            }
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.cannotRemoveS3File(e);
        }
    }
}

