/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public enum BindingType {
    SIMPLE("simple"),
    OBJECT_FACTORY("object-factory"),
    LOOKUP("lookup"),
    EXTERNAL_CONTEXT("external-context");

    private static final Map<String, BindingType> MAP;
    private final String localName;

    public static BindingType forName(String localName) {
        if (localName == null) {
            return null;
        }
        BindingType directoryGrouping = MAP.get(localName.toLowerCase(Locale.ENGLISH));
        return directoryGrouping == null ? BindingType.valueOf(localName.toUpperCase(Locale.ENGLISH)) : directoryGrouping;
    }

    private BindingType(String localName) {
        this.localName = localName;
    }

    public String toString() {
        return this.localName;
    }

    public ModelNode toModelNode() {
        return new ModelNode().set(this.toString());
    }

    static {
        HashMap<String, BindingType> map = new HashMap<String, BindingType>();
        for (BindingType directoryGrouping : BindingType.values()) {
            map.put(directoryGrouping.localName, directoryGrouping);
        }
        MAP = map;
    }
}

