/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.modules.ClassLoaderLocalLoader;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.JDKPaths;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.PropertyReadAction;
import sun.reflect.Reflection;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    private static Hack hack = AccessController.doPrivileged(new PrivilegedAction<Hack>(){

        @Override
        public Hack run() {
            return new Hack();
        }
    });
    private static final MethodHandle getPackageMH;
    private static final boolean hasGetCallerClass;
    private static final int callerOffset;

    JDKSpecific() {
    }

    static JarFile getJarFile(String name, boolean verify) throws IOException {
        return new JarFile(name, verify);
    }

    static JarFile getJarFile(File name, boolean verify) throws IOException {
        return new JarFile(name, verify);
    }

    static Class<?> getCallingUserClass() {
        Class<?>[] stack = hack.getClassContext();
        int i = 3;
        while (stack[i] == stack[2]) {
            if (++i < stack.length) continue;
            return null;
        }
        return stack[i];
    }

    static Class<?> getCallingClass() {
        if (hasGetCallerClass) {
            return Reflection.getCallerClass((int)(2 + callerOffset));
        }
        return hack.getClassContext()[2 + callerOffset];
    }

    static boolean isParallelCapable(ConcurrentClassLoader cl) {
        return ConcurrentClassLoader.getLockForClass(cl, "$TEST$") != cl;
    }

    static Package getPackage(ClassLoader cl, String packageName) {
        try {
            return getPackageMH.invoke(cl, packageName);
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable throwable) {
            throw new UndeclaredThrowableException(throwable);
        }
    }

    static Set<String> getJDKPaths() {
        FastCopyHashSet<String> pathSet = new FastCopyHashSet<String>(1024);
        FastCopyHashSet<String> jarSet = new FastCopyHashSet<String>(1024);
        String sunBootClassPath = AccessController.doPrivileged(new PropertyReadAction("sun.boot.class.path"));
        String javaClassPath = AccessController.doPrivileged(new PropertyReadAction("java.class.path"));
        JDKPaths.processClassPathItem(sunBootClassPath, jarSet, pathSet);
        JDKPaths.processClassPathItem(javaClassPath, jarSet, pathSet);
        pathSet.add("org/jboss/modules");
        pathSet.add("org/jboss/modules/filter");
        pathSet.add("org/jboss/modules/log");
        pathSet.add("org/jboss/modules/management");
        pathSet.add("org/jboss/modules/ref");
        return Collections.unmodifiableSet(pathSet);
    }

    static LocalLoader getSystemLocalLoader() {
        return new ClassLoaderLocalLoader(JDKSpecific.getPlatformClassLoader());
    }

    static ClassLoader getPlatformClassLoader() {
        return JDKSpecific.class.getClassLoader();
    }

    static URL getSystemResource(String name) {
        ClassLoader classLoader = JDKSpecific.getPlatformClassLoader();
        return classLoader != null ? classLoader.getResource(name) : ClassLoader.getSystemResource(name);
    }

    static Enumeration<URL> getSystemResources(String name) throws IOException {
        ClassLoader classLoader = JDKSpecific.getPlatformClassLoader();
        return classLoader != null ? classLoader.getResources(name) : ClassLoader.getSystemResources(name);
    }

    static InputStream getSystemResourceAsStream(String name) {
        ClassLoader classLoader = JDKSpecific.getPlatformClassLoader();
        return classLoader != null ? classLoader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
    }

    static Class<?> getSystemClass(ConcurrentClassLoader caller, String className) throws ClassNotFoundException {
        ClassLoader platformClassLoader = JDKSpecific.getPlatformClassLoader();
        return platformClassLoader != null ? platformClassLoader.loadClass(className) : caller.findSystemClassInternal(className);
    }

    static {
        try {
            getPackageMH = MethodHandles.lookup().unreflect(AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    for (Method method : ClassLoader.class.getDeclaredMethods()) {
                        Class<?>[] parameterTypes;
                        if (!method.getName().equals("getPackage") || (parameterTypes = method.getParameterTypes()).length != 1 || parameterTypes[0] != String.class) continue;
                        method.setAccessible(true);
                        return method;
                    }
                    throw new IllegalStateException("No getPackage method found on ClassLoader");
                }
            }));
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
        boolean result = false;
        int offset = 0;
        try {
            result = Reflection.getCallerClass((int)1) == JDKSpecific.class || Reflection.getCallerClass((int)2) == JDKSpecific.class;
            offset = Reflection.getCallerClass((int)1) == Reflection.class ? 2 : 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hasGetCallerClass = result;
        callerOffset = offset;
    }

    static final class Hack
    extends SecurityManager {
        Hack() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

