/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.IterableLocalLoader;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Metrics;
import org.jboss.modules.Module;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Paths;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.security.ModularProtectionDomain;

public class ModuleClassLoader
extends ConcurrentClassLoader {
    private final Module module;
    private final ClassFileTransformer transformer;
    private final AtomicReference<Paths<ResourceLoader, ResourceLoaderSpec>> paths = new AtomicReference(Paths.none());
    private final LocalLoader localLoader = new IterableLocalLoader(){

        @Override
        public Class<?> loadClassLocal(String name, boolean resolve) {
            try {
                return ModuleClassLoader.this.loadClassLocal(name, resolve);
            }
            catch (ClassNotFoundException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                return null;
            }
        }

        @Override
        public Package loadPackageLocal(String name) {
            return ModuleClassLoader.this.findLoadedPackage(name);
        }

        @Override
        public List<Resource> loadResourceLocal(String name) {
            return ModuleClassLoader.this.loadResourceLocal(name);
        }

        @Override
        public Iterator<Resource> iterateResources(String startPath, boolean recursive) {
            return ModuleClassLoader.this.iterateResources(startPath, recursive);
        }

        public String toString() {
            return "local loader for " + ModuleClassLoader.this.toString();
        }
    };
    private final IdentityHashMap<CodeSource, ProtectionDomain> protectionDomains = new IdentityHashMap();

    protected ModuleClassLoader(Configuration configuration) {
        super(configuration.getModule().getModuleLoader().getModuleDescription(configuration.getModule()));
        this.module = configuration.getModule();
        this.paths.lazySet(new Paths(configuration.getResourceLoaders(), Collections.emptyMap()));
        AssertionSetting setting = configuration.getAssertionSetting();
        if (setting != AssertionSetting.INHERIT) {
            this.setDefaultAssertionStatus(setting == AssertionSetting.ENABLED);
        }
        this.transformer = configuration.getTransformer();
    }

    boolean recalculate() {
        Paths<ResourceLoader, ResourceLoaderSpec> paths = this.paths.get();
        return this.setResourceLoaders(paths, paths.getSourceList((ResourceLoaderSpec[])ResourceLoaderSpec.NO_RESOURCE_LOADERS));
    }

    boolean setResourceLoaders(ResourceLoaderSpec[] resourceLoaders) {
        return this.setResourceLoaders(this.paths.get(), resourceLoaders);
    }

    private boolean setResourceLoaders(Paths<ResourceLoader, ResourceLoaderSpec> paths, ResourceLoaderSpec[] resourceLoaders) {
        HashMap allPaths = new HashMap();
        for (ResourceLoaderSpec loaderSpec : resourceLoaders) {
            ResourceLoader loader = loaderSpec.getResourceLoader();
            PathFilter filter = loaderSpec.getPathFilter();
            for (String path : loader.getPaths()) {
                if (!filter.accept(path)) continue;
                List allLoaders = (List)allPaths.get(path);
                if (allLoaders == null) {
                    ArrayList<ResourceLoader> newList = new ArrayList<ResourceLoader>(16);
                    newList.add(loader);
                    allPaths.put(path, newList);
                    continue;
                }
                allLoaders.add(loader);
            }
        }
        return this.paths.compareAndSet(paths, new Paths(resourceLoaders, allPaths));
    }

    LocalLoader getLocalLoader() {
        return this.localLoader;
    }

    @Override
    protected final Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(className);
        if (loadedClass != null) {
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
        ModuleLogger log = Module.log;
        Module module = this.module;
        log.trace("Finding class %s from %s", (Object)className, (Object)module);
        Class<?> clazz = module.loadModuleClass(className, resolve);
        if (clazz != null) {
            return clazz;
        }
        log.trace("Class %s not found from %s", (Object)className, (Object)module);
        throw new ClassNotFoundException(this.getClassNotFoundExceptionMessage(className, module));
    }

    protected String getClassNotFoundExceptionMessage(String className, Module fromModule) {
        return className + " from [" + fromModule + "]";
    }

    public Class<?> loadClassLocal(String className) throws ClassNotFoundException {
        return this.loadClassLocal(className, false);
    }

    public Class<?> loadClassLocal(String className, boolean resolve) throws ClassNotFoundException {
        Module module;
        ModuleLogger log;
        block13: {
            log = Module.log;
            module = this.module;
            log.trace("Finding local class %s from %s", (Object)className, (Object)module);
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                log.trace("Found previously loaded %s from %s", (Object)loadedClass, (Object)module);
                if (resolve) {
                    this.resolveClass(loadedClass);
                }
                return loadedClass;
            }
            Map<String, List<ResourceLoader>> paths = this.paths.get().getAllPaths();
            log.trace("Loading class %s locally from %s", (Object)className, (Object)module);
            String pathOfClass = Module.pathOfClass(className);
            List<ResourceLoader> loaders = paths.get(pathOfClass);
            if (loaders == null) {
                return null;
            }
            try {
                if (loaders.size() <= 0) break block13;
                String fileName = Module.fileNameOfClass(className);
                for (ResourceLoader loader : loaders) {
                    ClassSpec classSpec = loader.getClassSpec(fileName);
                    if (classSpec == null) continue;
                    ResourceLoader resourceLoader = loader;
                    try {
                        this.preDefine(classSpec, className);
                    }
                    catch (Throwable th) {
                        throw new ClassNotFoundException("Failed to preDefine class: " + className, th);
                    }
                    Class<?> clazz = this.defineClass(className, classSpec, resourceLoader);
                    try {
                        this.postDefine(classSpec, clazz);
                    }
                    catch (Throwable th) {
                        throw new ClassNotFoundException("Failed to postDefine class: " + className, th);
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className, e);
            }
            catch (RuntimeException e) {
                log.trace(e, "Unexpected runtime exception in module loader");
                throw new ClassNotFoundException(className, e);
            }
            catch (Error e) {
                log.trace(e, "Unexpected error in module loader");
                throw e;
            }
        }
        log.trace("No local specification found for class %s in %s", (Object)className, (Object)module);
        return null;
    }

    Resource loadResourceLocal(String root, String name) {
        String path;
        Map<String, List<ResourceLoader>> paths = this.paths.get().getAllPaths();
        List<ResourceLoader> loaders = paths.get(path = Module.pathOf(name));
        if (loaders == null) {
            return null;
        }
        for (ResourceLoader loader : loaders) {
            if (!root.equals(loader.getRootName())) continue;
            return loader.getResource(name);
        }
        return null;
    }

    public List<Resource> loadResourceLocal(String name) {
        String path;
        Map<String, List<ResourceLoader>> paths = this.paths.get().getAllPaths();
        List<ResourceLoader> loaders = paths.get(path = Module.pathOf(name));
        if (loaders == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(loaders.size());
        for (ResourceLoader loader : loaders) {
            Resource resource = loader.getResource(name);
            if (resource == null) continue;
            list.add(resource);
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    private Class<?> doDefineOrLoadClass(String className, byte[] bytes, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) {
        try {
            Class<?> definedClass = bytes != null ? this.defineClass(className, bytes, 0, bytes.length, protectionDomain) : this.defineClass(className, byteBuffer, protectionDomain);
            this.module.getModuleLoader().incClassCount();
            return definedClass;
        }
        catch (LinkageError e) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                this.module.getModuleLoader().incRaceCount();
                return loadedClass;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        IdentityHashMap<CodeSource, ProtectionDomain> map;
        IdentityHashMap<CodeSource, ProtectionDomain> identityHashMap = map = this.protectionDomains;
        synchronized (identityHashMap) {
            ProtectionDomain protectionDomain = map.get(codeSource);
            if (protectionDomain == null) {
                PermissionCollection permissions = this.module.getPermissionCollection();
                protectionDomain = new ModularProtectionDomain(codeSource, permissions, this);
                map.put(codeSource, protectionDomain);
            }
            return protectionDomain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> defineClass(String name, ClassSpec classSpec, ResourceLoader resourceLoader) {
        Class<?> newClass;
        ModuleLogger log = Module.log;
        Module module = this.module;
        log.trace("Attempting to define class %s in %s", (Object)name, (Object)module);
        int lastIdx = name.lastIndexOf(46);
        if (lastIdx != -1) {
            String packageName = name.substring(0, lastIdx);
            ModuleClassLoader moduleClassLoader = this;
            synchronized (moduleClassLoader) {
                Package pkg = this.findLoadedPackage(packageName);
                if (pkg == null) {
                    try {
                        pkg = this.definePackage(packageName, resourceLoader.getPackageSpec(packageName));
                    }
                    catch (IOException e) {
                        pkg = this.definePackage(packageName, null);
                    }
                }
                if (pkg.isSealed() && !pkg.isSealed(classSpec.getCodeSource().getLocation())) {
                    log.trace("Detected a sealing violation (attempt to define class %s in sealed package %s in %s)", (Object)name, (Object)packageName, (Object)module);
                    throw new SecurityException("sealing violation: package " + packageName + " is sealed");
                }
            }
        }
        try {
            byte[] bytes = classSpec.getBytes();
            ByteBuffer byteBuffer = classSpec.getByteBuffer();
            try {
                ProtectionDomain protectionDomain = this.getProtectionDomain(classSpec.getCodeSource());
                if (this.transformer != null) {
                    if (bytes == null) {
                        ByteBuffer dup = byteBuffer.duplicate();
                        byteBuffer = null;
                        bytes = new byte[dup.remaining()];
                        dup.get(bytes);
                    }
                    try {
                        bytes = this.transformer.transform(this, name.replace('.', '/'), null, protectionDomain, bytes);
                    }
                    catch (Exception e) {
                        ClassFormatError error = new ClassFormatError(e.getMessage());
                        error.initCause(e);
                        throw error;
                    }
                }
                long start = Metrics.getCurrentCPUTime();
                newClass = this.doDefineOrLoadClass(name, bytes, byteBuffer, protectionDomain);
                module.getModuleLoader().addClassLoadTime(Metrics.getCurrentCPUTime() - start);
                log.classDefined(name, module);
            }
            catch (LinkageError e) {
                Error ne;
                try {
                    String oldMsg = e.getMessage();
                    String newMsg = "Failed to link " + name.replace('.', '/') + " (" + module + ")";
                    ne = (Error)e.getClass().getConstructor(String.class).newInstance(oldMsg == null || oldMsg.isEmpty() ? newMsg : newMsg + ": " + oldMsg);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
                    throw e;
                }
                throw ne;
            }
        }
        catch (Error | RuntimeException e) {
            log.classDefineFailed(e, name, module);
            throw e;
        }
        AssertionSetting setting = classSpec.getAssertionSetting();
        if (setting != AssertionSetting.INHERIT) {
            this.setClassAssertionStatus(name, setting == AssertionSetting.ENABLED);
        }
        return newClass;
    }

    protected void preDefine(ClassSpec classSpec, String className) {
    }

    protected void postDefine(ClassSpec classSpec, Class<?> definedClass) {
    }

    private Package definePackage(String name, PackageSpec spec) {
        Package pkg;
        Module module = this.module;
        ModuleLogger log = Module.log;
        log.trace("Attempting to define package %s in %s", (Object)name, (Object)module);
        if (spec == null) {
            pkg = this.definePackage(name, null, null, null, null, null, null, null);
        } else {
            pkg = this.definePackage(name, spec.getSpecTitle(), spec.getSpecVersion(), spec.getSpecVendor(), spec.getImplTitle(), spec.getImplVersion(), spec.getImplVendor(), spec.getSealBase());
            AssertionSetting setting = spec.getAssertionSetting();
            if (setting != AssertionSetting.INHERIT) {
                this.setPackageAssertionStatus(name, setting == AssertionSetting.ENABLED);
            }
        }
        log.trace("Defined package %s in %s", (Object)name, (Object)module);
        return pkg;
    }

    @Override
    protected final String findLibrary(String libname) {
        ModuleLogger log = Module.log;
        log.trace("Attempting to load native library %s from %s", (Object)libname, (Object)this.module);
        for (ResourceLoaderSpec loader : this.paths.get().getSourceList((ResourceLoaderSpec[])ResourceLoaderSpec.NO_RESOURCE_LOADERS)) {
            String library = loader.getResourceLoader().getLibrary(libname);
            if (library == null) continue;
            return library;
        }
        return null;
    }

    @Override
    public final URL findResource(String name, boolean exportsOnly) {
        return this.module.getResource(name);
    }

    @Override
    public final Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return this.module.getResources(name);
    }

    @Override
    public final InputStream findResourceAsStream(String name, boolean exportsOnly) {
        try {
            return this.module.getResourceAsStream(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public final Module getModule() {
        return this.module;
    }

    @Override
    public final String getName() {
        return super.getName();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + " for " + this.module;
    }

    Set<String> getPaths() {
        return this.paths.get().getAllPaths().keySet();
    }

    @Override
    protected final Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    protected final Package getPackageByName(String name) {
        Package loaded = this.findLoadedPackage(name);
        if (loaded != null) {
            return loaded;
        }
        return this.module.getPackage(name);
    }

    @Override
    protected final Package[] getPackages() {
        return this.module.getPackages();
    }

    @Override
    public final void setDefaultAssertionStatus(boolean enabled) {
        super.setDefaultAssertionStatus(enabled);
    }

    @Override
    public final void setPackageAssertionStatus(String packageName, boolean enabled) {
        super.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public final void setClassAssertionStatus(String className, boolean enabled) {
        super.setClassAssertionStatus(className, enabled);
    }

    @Override
    public final void clearAssertionStatus() {
        super.clearAssertionStatus();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected final void finalize() throws Throwable {
        super.finalize();
    }

    ResourceLoader[] getResourceLoaders() {
        ResourceLoaderSpec[] specs = this.paths.get().getSourceList((ResourceLoaderSpec[])ResourceLoaderSpec.NO_RESOURCE_LOADERS);
        int length = specs.length;
        ResourceLoader[] loaders = new ResourceLoader[length];
        for (int i = 0; i < length; ++i) {
            loaders[i] = specs[i].getResourceLoader();
        }
        return loaders;
    }

    public final Iterator<Resource> iterateResources(String startName, boolean recurse) {
        String realStartName = PathUtils.canonicalize(PathUtils.relativize(startName));
        final PathFilter filter = recurse ? (realStartName.isEmpty() ? PathFilters.acceptAll() : PathFilters.any(PathFilters.is(realStartName), PathFilters.isChildOf(realStartName))) : PathFilters.is(realStartName);
        Map<String, List<ResourceLoader>> paths = this.paths.get().getAllPaths();
        final Iterator<Map.Entry<String, List<ResourceLoader>>> iterator = paths.entrySet().iterator();
        return new Iterator<Resource>(){
            private String path;
            private Iterator<Resource> resourceIterator;
            private Iterator<ResourceLoader> loaderIterator;
            private Resource next;

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.resourceIterator != null) {
                        assert (this.path != null);
                        if (this.resourceIterator.hasNext()) {
                            this.next = this.resourceIterator.next();
                            return true;
                        }
                        this.resourceIterator = null;
                    }
                    if (this.loaderIterator != null) {
                        ResourceLoader loader;
                        assert (this.path != null);
                        if (this.loaderIterator.hasNext() && (loader = this.loaderIterator.next()) instanceof IterableResourceLoader) {
                            this.resourceIterator = ((IterableResourceLoader)loader).iterateResources(this.path, false);
                            continue;
                        }
                        this.loaderIterator = null;
                    }
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)iterator.next();
                    this.path = (String)entry.getKey();
                    if (!filter.accept(this.path)) continue;
                    this.loaderIterator = ((List)entry.getValue()).iterator();
                }
                return true;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Resource resource = this.next;
                    return resource;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public final Set<String> getLocalPaths() {
        return Collections.unmodifiableSet(this.paths.get().getAllPaths().keySet());
    }

    static {
        boolean parallelOk = true;
        try {
            parallelOk = ClassLoader.registerAsParallelCapable();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!parallelOk) {
            throw new Error("Failed to register " + ModuleClassLoader.class.getName() + " as parallel-capable");
        }
    }

    public static final class Configuration {
        private final Module module;
        private final AssertionSetting assertionSetting;
        private final ResourceLoaderSpec[] resourceLoaders;
        private final ClassFileTransformer transformer;

        Configuration(Module module, AssertionSetting assertionSetting, ResourceLoaderSpec[] resourceLoaders, ClassFileTransformer transformer) {
            this.module = module;
            this.assertionSetting = assertionSetting;
            this.resourceLoaders = resourceLoaders;
            this.transformer = transformer;
        }

        Module getModule() {
            return this.module;
        }

        AssertionSetting getAssertionSetting() {
            return this.assertionSetting;
        }

        ResourceLoaderSpec[] getResourceLoaders() {
            return this.resourceLoaders;
        }

        ClassFileTransformer getTransformer() {
            return this.transformer;
        }
    }
}

