/*
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.weld;

import org.jboss.as.server.deployment.AttachmentKey;

/**
 * Immutable representation of Weld configuration in <code>jboss-all.xml<code>.
 * This configuration is processed by {@link org.jboss.as.weld.deployment.processors.WeldConfigurationProcessor}.
 *
 * @author Jozef Hartinger
 *
 */
public class WeldJBossAllConfiguration {

    public static final AttachmentKey<WeldJBossAllConfiguration> ATTACHMENT_KEY = AttachmentKey.create(WeldJBossAllConfiguration.class);

    private final Boolean requireBeanDescriptor;
    private final Boolean nonPortableMode;

    WeldJBossAllConfiguration(Boolean requireBeanDescriptor, Boolean nonPortableMode) {
        this.requireBeanDescriptor = requireBeanDescriptor;
        this.nonPortableMode = nonPortableMode;
    }

    public Boolean getNonPortableMode() {
        return nonPortableMode;
    }

    public Boolean getRequireBeanDescriptor() {
        return requireBeanDescriptor;
    }
}
