/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service.internal.tsr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.as.txn.logging.TransactionLogger;

public class JCAOrderedLastSynchronizationList
implements Synchronization {
    private com.arjuna.ats.jta.transaction.Transaction tx;
    private Map<Transaction, JCAOrderedLastSynchronizationList> jcaOrderedLastSynchronizations;
    private List<Synchronization> preJcaSyncs = new ArrayList<Synchronization>();
    private List<Synchronization> jcaSyncs = new ArrayList<Synchronization>();

    public JCAOrderedLastSynchronizationList(com.arjuna.ats.jta.transaction.Transaction tx, Map<Transaction, JCAOrderedLastSynchronizationList> jcaOrderedLastSynchronizations) {
        this.tx = tx;
        this.jcaOrderedLastSynchronizations = jcaOrderedLastSynchronizations;
    }

    public void registerInterposedSynchronization(Synchronization synchronization) throws IllegalStateException, SystemException {
        int status = this.tx.getStatus();
        switch (status) {
            case 0: 
            case 7: {
                break;
            }
            default: {
                throw TransactionLogger.ROOT_LOGGER.syncsnotallowed(status);
            }
        }
        if (synchronization.getClass().getName().startsWith("org.jboss.jca")) {
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.jcaSyncs.add - Class: " + synchronization.getClass() + " HashCode: " + synchronization.hashCode() + " toString: " + synchronization);
            }
            this.jcaSyncs.add(synchronization);
        } else {
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.preJcaSyncs.add - Class: " + synchronization.getClass() + " HashCode: " + synchronization.hashCode() + " toString: " + synchronization);
            }
            this.preJcaSyncs.add(synchronization);
        }
    }

    public void beforeCompletion() {
        int lastIndexProcessed;
        for (lastIndexProcessed = 0; lastIndexProcessed < this.preJcaSyncs.size(); ++lastIndexProcessed) {
            Synchronization preJcaSync = this.preJcaSyncs.get(lastIndexProcessed);
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.preJcaSyncs.before_completion - Class: " + preJcaSync.getClass() + " HashCode: " + preJcaSync.hashCode() + " toString: " + preJcaSync);
            }
            preJcaSync.beforeCompletion();
        }
        for (lastIndexProcessed = 0; lastIndexProcessed < this.jcaSyncs.size(); ++lastIndexProcessed) {
            Synchronization jcaSync = this.jcaSyncs.get(lastIndexProcessed);
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.jcaSyncs.before_completion - Class: " + jcaSync.getClass() + " HashCode: " + jcaSync.hashCode() + " toString: " + jcaSync);
            }
            jcaSync.beforeCompletion();
        }
    }

    public void afterCompletion(int status) {
        Collections.reverse(this.preJcaSyncs);
        for (Synchronization preJcaSync : this.preJcaSyncs) {
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.preJcaSyncs.afterCompletion - Class: " + preJcaSync.getClass() + " HashCode: " + preJcaSync.hashCode() + " toString: " + preJcaSync);
            }
            try {
                preJcaSync.afterCompletion(status);
            }
            catch (Exception e) {
                TransactionLogger.ROOT_LOGGER.preJcaSyncAfterCompletionFailed(preJcaSync, (Transaction)this.tx, e);
            }
        }
        Collections.reverse(this.jcaSyncs);
        for (Synchronization jcaSync : this.jcaSyncs) {
            if (TransactionLogger.ROOT_LOGGER.isTraceEnabled()) {
                TransactionLogger.ROOT_LOGGER.trace("JCAOrderedLastSynchronizationList.jcaSyncs.afterCompletion - Class: " + jcaSync.getClass() + " HashCode: " + jcaSync.hashCode() + " toString: " + jcaSync);
            }
            try {
                jcaSync.afterCompletion(status);
            }
            catch (Exception e) {
                TransactionLogger.ROOT_LOGGER.jcaSyncAfterCompletionFailed(jcaSync, (Transaction)this.tx, e);
            }
        }
        if (this.jcaOrderedLastSynchronizations.remove(this.tx) == null) {
            Transaction altKey = null;
            Iterator<Map.Entry<Transaction, JCAOrderedLastSynchronizationList>> iterator = this.jcaOrderedLastSynchronizations.entrySet().iterator();
            while (altKey == null && iterator.hasNext()) {
                Map.Entry<Transaction, JCAOrderedLastSynchronizationList> next = iterator.next();
                if (!next.getValue().equals(this)) continue;
                altKey = next.getKey();
                iterator.remove();
                if (!TransactionLogger.ROOT_LOGGER.isTraceEnabled()) break;
                TransactionLogger.ROOT_LOGGER.tracef("Removed: %s [%s]", System.identityHashCode(this.tx), this.tx.toString());
                break;
            }
            if (altKey == null) {
                TransactionLogger.ROOT_LOGGER.transactionNotFound((Transaction)this.tx);
            }
        }
    }
}

