/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.http2.Http2OpenListener;
import io.undertow.server.protocol.spdy.SpdyOpenListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.SslConnection;

public class HttpsListenerService
extends HttpListenerService {
    private final InjectedValue<SecurityRealm> securityRealm = new InjectedValue();
    private volatile AcceptingChannel<SslConnection> sslServer;
    static final String PROTOCOL = "https";

    public HttpsListenerService(String name, String serverName, OptionMap listenerOptions, OptionMap socketOptions) {
        super(name, serverName, listenerOptions, socketOptions, false, false);
    }

    @Override
    protected OpenListener createOpenListener() {
        if (this.listenerOptions.get(UndertowOptions.ENABLE_HTTP2, false) || this.listenerOptions.get(UndertowOptions.ENABLE_SPDY, false)) {
            try {
                this.getClass().getClassLoader().loadClass("org.eclipse.jetty.alpn.ALPN");
                return this.createAlpnOpenListener();
            }
            catch (ClassNotFoundException e) {
                UndertowLogger.ROOT_LOGGER.alpnNotFound();
                return super.createOpenListener();
            }
        }
        return super.createOpenListener();
    }

    private OpenListener createAlpnOpenListener() {
        OptionMap undertowOptions = OptionMap.builder().addAll(commonOptions).addAll(this.listenerOptions).set(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, this.getUndertowService().isStatisticsEnabled()).getMap();
        Pool bufferPool = (Pool)this.getBufferPool().getValue();
        HttpOpenListener http = new HttpOpenListener(bufferPool, undertowOptions);
        AlpnOpenListener alpn = new AlpnOpenListener(bufferPool, undertowOptions, (DelegateOpenListener)http);
        if (this.listenerOptions.get(UndertowOptions.ENABLE_HTTP2, false)) {
            Http2OpenListener http2 = new Http2OpenListener(bufferPool, undertowOptions, "h2");
            alpn.addProtocol("h2", (DelegateOpenListener)http2, 10);
            Http2OpenListener http2_14 = new Http2OpenListener(bufferPool, undertowOptions, "h2-14");
            alpn.addProtocol("h2-14", (DelegateOpenListener)http2_14, 9);
        }
        if (this.listenerOptions.get(UndertowOptions.ENABLE_SPDY, false)) {
            SpdyOpenListener spdyOpenListener = new SpdyOpenListener(bufferPool, bufferPool, undertowOptions);
            alpn.addProtocol("spdy/3.1", (DelegateOpenListener)spdyOpenListener, 5);
        }
        return alpn;
    }

    @Override
    protected void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        SSLContext sslContext = ((SecurityRealm)this.securityRealm.getValue()).getSSLContext();
        OptionMap.Builder builder = OptionMap.builder().addAll(commonOptions);
        builder.addAll(this.socketOptions);
        builder.set(Options.USE_DIRECT_BUFFERS, true);
        OptionMap combined = builder.getMap();
        UndertowXnioSsl xnioSsl = new UndertowXnioSsl(worker.getXnio(), combined, sslContext);
        this.sslServer = xnioSsl.createSslConnectionServer(worker, socketAddress, acceptListener, combined);
        this.sslServer.resumeAccepts();
        UndertowLogger.ROOT_LOGGER.listenerStarted("HTTPS", this.getName(), socketAddress);
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    protected void stopListening() {
        this.sslServer.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("HTTPS", this.getName());
        IoUtils.safeClose(this.sslServer);
        this.sslServer = null;
        UndertowLogger.ROOT_LOGGER.listenerStopped("HTTPS", this.getName(), ((SocketBinding)this.getBinding().getValue()).getSocketAddress());
        ((ListenerRegistry)this.httpListenerRegistry.getValue()).removeListener(this.getName());
    }

    public InjectedValue<SecurityRealm> getSecurityRealm() {
        return this.securityRealm;
    }

    @Override
    protected String getProtocol() {
        return PROTOCOL;
    }
}

