/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.LocationDefinition;
import org.wildfly.extension.undertow.LocationService;
import org.wildfly.extension.undertow.UndertowService;

final class LocationAdd
extends AbstractAddStepHandler {
    static LocationAdd INSTANCE = new LocationAdd();

    private LocationAdd() {
        super(new AttributeDefinition[]{LocationDefinition.HANDLER});
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress hostAddress = context.getCurrentAddress().getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String name = context.getCurrentAddressValue();
        String handler = LocationDefinition.HANDLER.resolveModelAttribute(context, model).asString();
        String serverName = serverAddress.getLastElement().getValue();
        String hostName = hostAddress.getLastElement().getValue();
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(LocationDefinition.LOCATION_CAPABILITY);
        Consumer sConsumer = sb.provides(LocationDefinition.LOCATION_CAPABILITY, UndertowService.locationServiceName(serverName, hostName, name), new ServiceName[0]);
        Supplier hhSupplier = sb.requiresCapability("org.wildfly.extension.undertow.handler", HttpHandler.class, new String[]{handler});
        Supplier hSupplier = sb.requiresCapability("org.wildfly.undertow.host", Host.class, new String[]{serverName, hostName});
        sb.setInstance((Service)new LocationService(sConsumer, hhSupplier, hSupplier, name));
        sb.install();
    }
}

