/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformersSubRegistration;

public interface TransformationDescription {
    public PathElement getPath();

    public PathAddressTransformer getPathAddressTransformer();

    public OperationTransformer getOperationTransformer();

    public ResourceTransformer getResourceTransformer();

    public Map<String, OperationTransformer> getOperationTransformers();

    public List<TransformationDescription> getChildren();

    public boolean isInherited();

    public Set<String> getDiscardedOperations();

    public boolean isPlaceHolder();

    public static final class Tools {
        private Tools() {
        }

        public static TransformersSubRegistration register(TransformationDescription description, TransformersSubRegistration parent) {
            TransformersSubRegistration registration = parent.registerSubResource(description.getPath(), description.getPathAddressTransformer(), description.getResourceTransformer(), description.getOperationTransformer(), description.isInherited(), description.isPlaceHolder());
            for (Map.Entry<String, OperationTransformer> entry : description.getOperationTransformers().entrySet()) {
                registration.registerOperationTransformer(entry.getKey(), entry.getValue());
            }
            registration.discardOperations(description.getDiscardedOperations().toArray(new String[description.getDiscardedOperations().size()]));
            for (TransformationDescription child : description.getChildren()) {
                Tools.register(child, registration);
            }
            return registration;
        }

        public static TransformersSubRegistration register(TransformationDescription description, SubsystemRegistration registration, ModelVersion ... versions) {
            return Tools.register(description, registration, ModelVersionRange.Versions.range(versions));
        }

        public static TransformersSubRegistration register(TransformationDescription description, SubsystemRegistration registration, ModelVersionRange range) {
            TransformersSubRegistration subRegistration = registration.registerModelTransformers(range, description.getResourceTransformer(), description.getOperationTransformer(), description.isPlaceHolder());
            for (Map.Entry<String, OperationTransformer> entry : description.getOperationTransformers().entrySet()) {
                subRegistration.registerOperationTransformer(entry.getKey(), entry.getValue());
            }
            for (TransformationDescription child : description.getChildren()) {
                Tools.register(child, subRegistration);
            }
            subRegistration.discardOperations(description.getDiscardedOperations().toArray(new String[description.getDiscardedOperations().size()]));
            return subRegistration;
        }
    }
}

