/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.File;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.DeploymentFileRepository;

public class LocalDeploymentFileRepository
implements DeploymentFileRepository {
    final File deploymentRoot;

    public LocalDeploymentFileRepository(File deploymentRoot) {
        this.deploymentRoot = deploymentRoot;
    }

    @Override
    public File[] getDeploymentFiles(ContentReference reference) {
        return this.getDeploymentRoot(reference).listFiles();
    }

    @Override
    public File getDeploymentRoot(ContentReference reference) {
        if (reference == null || reference.getHexHash().isEmpty()) {
            return this.deploymentRoot;
        }
        String hex = reference.getHexHash();
        File first = new File(this.deploymentRoot, hex.substring(0, 2));
        return new File(first, hex.substring(2));
    }

    @Override
    public void deleteDeployment(ContentReference reference) {
        File deployment = this.getDeploymentRoot(reference);
        if (deployment != this.deploymentRoot) {
            this.deleteRecursively(deployment);
            if (deployment.getParentFile().list().length == 0) {
                deployment.getParentFile().delete();
            }
        }
    }

    private void deleteRecursively(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (String name : file.list()) {
                    this.deleteRecursively(new File(file, name));
                }
            }
            file.delete();
        }
    }
}

