/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.apache.ws.jaxme.xs.XSParser;
import org.xml.sax.InputSource;

public class TestSrcContent
extends TestCase {
    public TestSrcContent(String name) {
        super(name);
    }

    public void testSourceFiles() throws Exception {
        File f;
        String path = System.getProperty("xstc.zip.file");
        if (path == null || "".equals(path)) {
            TestSrcContent.fail((String)"The property xstc.zip.file is not set.");
        }
        if (!(f = new File(path)).exists() || !f.isFile()) {
            TestSrcContent.fail((String)("The file " + f.getAbsolutePath() + ", given by property xstc.zip.file, does not exist "));
        }
        int passXSDFiles = 0;
        int failXSDFiles = 0;
        ZipFile zipFile = new ZipFile(f);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            String name;
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).endsWith(".xsd")) continue;
            InputSource iSource = new InputSource(zipFile.getInputStream(entry));
            iSource.setSystemId(name);
            System.out.print(name);
            XSParser parser = new XSParser();
            parser.setValidating(false);
            try {
                parser.parseSyntax(iSource);
                ++passXSDFiles;
                System.out.println(": PASS");
            }
            catch (Exception e) {
                ++failXSDFiles;
                System.out.println(": FAIL");
                e.printStackTrace(System.out);
            }
        }
        System.out.println();
        System.out.println();
        System.out.println("Total files = " + (passXSDFiles + failXSDFiles));
        System.out.println("Passed      = " + passXSDFiles);
        System.out.println("Failed      = " + failXSDFiles);
    }

    public static void main(String[] args) throws Exception {
        TestSrcContent testSrcContent = new TestSrcContent(TestSrcContent.class.getName());
        testSrcContent.testSourceFiles();
    }
}

