/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.parser.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.parser.ChildSetter;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.XsSAXParser;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ChildSetterImpl
implements ChildSetter {
    private static final Class[] GETCHILDHANDLER_CLASSES = new Class[]{String.class, String.class, String.class};
    private static final Class[] ZERO_CLASSES = new Class[0];
    private static final Object[] ZERO_OBJECTS = new Object[0];

    private XSContext getData() {
        return XSParser.getRunningInstance().getContext();
    }

    protected Object invokeMethod(Object pBean, Method pMethod, String pName, Object[] pArgs) throws SAXException {
        try {
            return pMethod.invoke(pBean, pArgs);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof SAXException) {
                throw (SAXException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to invoke method " + pMethod.getName() + " of class " + pMethod.getDeclaringClass() + " with argument " + pBean + ": IllegalAccessException, " + e.getMessage());
        }
    }

    public ContentHandler getChildHandler(String pQName, String pNamespaceURI, String pLocalName) throws SAXException {
        XsSAXParser xsSAXParser = (XsSAXParser)this.getData().getCurrentContentHandler();
        if (xsSAXParser == null) {
            throw new NullPointerException("No XsSAXParser registered.");
        }
        Object bean = xsSAXParser.getBean();
        Class<?> beanClass = bean.getClass();
        try {
            ContentHandler result;
            Method m = beanClass.getMethod("getChildHandler", GETCHILDHANDLER_CLASSES);
            if (Modifier.isPublic(m.getModifiers()) && ContentHandler.class.isAssignableFrom(m.getReturnType()) && (result = (ContentHandler)this.invokeMethod(bean, m, pQName, new Object[]{pQName, pNamespaceURI, pLocalName})) != null) {
                return result;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        ContentHandler result = this.getChildHandler(xsSAXParser, pQName, pLocalName);
        if (result == null) {
            throw new LocSAXException("Unknown child element '" + pQName + "' for bean " + bean.getClass().getName(), this.getData().getLocator());
        }
        return result;
    }

    protected ContentHandler newXsSAXParser(XsSAXParser pParent, Object pBean) {
        return this.getData().getXsObjectFactory().newXsSAXParser(pBean);
    }

    protected ContentHandler getChildHandler(ContentHandler pParent, String pQName, String pLocalName) throws SAXException {
        XsSAXParser xsSAXParser = (XsSAXParser)pParent;
        Object bean = xsSAXParser.getBean();
        Class<?> beanClass = bean.getClass();
        String s = Character.toUpperCase(pLocalName.charAt(0)) + pLocalName.substring(1);
        try {
            Method m = beanClass.getMethod("create" + s, ZERO_CLASSES);
            if (Modifier.isPublic(m.getModifiers()) && !Void.TYPE.equals(m.getReturnType())) {
                Object result = this.invokeMethod(bean, m, pQName, ZERO_OBJECTS);
                return this.newXsSAXParser(xsSAXParser, result);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SAXException e) {
            throw e;
        }
        return null;
    }
}

