/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.parser.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.parser.TextSetter;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.XsSAXParser;
import org.xml.sax.SAXException;

public class TextSetterImpl
implements TextSetter {
    private static final Class[] ONE_STRING_CLASS = new Class[]{String.class};

    protected XSContext getData() {
        return XSParser.getRunningInstance().getContext();
    }

    protected boolean isIgnorable(String pText) {
        for (int i = 0; i < pText.length(); ++i) {
            if (Character.isWhitespace(pText.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void addText(String pText) throws SAXException {
        XsSAXParser handler = (XsSAXParser)this.getData().getCurrentContentHandler();
        Object bean = handler.getBean();
        try {
            Method m = bean.getClass().getMethod("addText", ONE_STRING_CLASS);
            m.invoke(bean, pText);
        }
        catch (NoSuchMethodException f) {
            if (this.isIgnorable(pText)) {
                return;
            }
            throw new IllegalStateException("Embedded text is not supported in the '" + handler.getQName() + "' element:" + pText);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Embedded text is not supported in the '" + handler.getQName() + "' element:" + pText);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof SAXException) {
                throw (SAXException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
    }
}

