/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.xs.xml.XsAnyURI;

public class XsNamespaceList {
    public static final XsNamespaceList ANY = new XsNamespaceList(){

        public boolean isAny() {
            return true;
        }
    };
    public static final XsNamespaceList OTHER = new XsNamespaceList(){

        public boolean isOther() {
            return true;
        }
    };
    private boolean isTargetNamespaceSet;
    private boolean isLocalSet;
    private List uris;

    XsNamespaceList() {
    }

    public static XsNamespaceList valueOf(String pValue) {
        if ("##any".equals(pValue)) {
            return ANY;
        }
        if ("##other".equals(pValue)) {
            return OTHER;
        }
        XsNamespaceList result = new XsNamespaceList();
        result.uris = new ArrayList();
        StringTokenizer st = new StringTokenizer(pValue);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if ("##targetNamespace".equals(s)) {
                result.isTargetNamespaceSet = true;
                continue;
            }
            if ("##local".equals(s)) {
                result.isLocalSet = true;
                continue;
            }
            result.uris.add(new XsAnyURI(s));
        }
        return result;
    }

    public boolean isAny() {
        return false;
    }

    public boolean isOther() {
        return false;
    }

    public XsAnyURI[] getUris() {
        if (this.uris == null) {
            return null;
        }
        return this.uris.toArray(new XsAnyURI[this.uris.size()]);
    }

    public boolean isTargetNamespaceSet() {
        return this.isTargetNamespaceSet;
    }

    public boolean isLocalSet() {
        return this.isLocalSet;
    }
}

