/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.mina.filter.codec.statemachine;

import org.apache.mina.common.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

/**
 * @author The Apache MINA Project (dev@mina.apache.org)
 * @version $Rev: 594010 $, $Date: 2007-11-12 11:42:05 +0900 (월, 12 11월 2007) $
 */
public abstract class IntegerDecodingState implements DecodingState {
    
    private int firstByte;
    private int secondByte;
    private int thirdByte;
    private int counter;

    public IntegerDecodingState() {
    }

    public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out)
            throws Exception {
        while (in.hasRemaining()) {
            switch (counter) {
            case 0:
                firstByte = in.getUnsigned();
                break;
            case 1:
                secondByte = in.getUnsigned();
                break;
            case 2:
                thirdByte = in.getUnsigned();
                break;
            case 3:
                counter = 0;
                return finishDecode(
                        (firstByte << 24) | (secondByte << 16) | (thirdByte << 8) | in.getUnsigned(),
                        out);
            default:
                throw new InternalError();
            }
            counter ++;
        }

        return this;
    }

    protected abstract DecodingState finishDecode(int value,
            ProtocolDecoderOutput out) throws Exception;
}
