/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mina.common.AbstractIoService;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIoException;
import org.apache.mina.common.TransportMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIoAcceptor
extends AbstractIoService
implements IoAcceptor {
    private final List<SocketAddress> localAddresses = new ArrayList<SocketAddress>();
    private final List<SocketAddress> unmodifiableLocalAddresses = Collections.unmodifiableList(this.localAddresses);
    private boolean disconnectOnUnbind = true;
    private boolean bound;
    protected final Object bindLock = new Object();

    protected AbstractIoAcceptor(IoSessionConfig sessionConfig) {
        super(sessionConfig);
    }

    @Override
    public SocketAddress getLocalAddress() {
        if (this.localAddresses.isEmpty()) {
            return null;
        }
        return this.localAddresses.iterator().next();
    }

    @Override
    public final void setLocalAddress(SocketAddress localAddress) {
        this.setLocalAddresses(localAddress);
    }

    @Override
    public final List<SocketAddress> getLocalAddresses() {
        return this.unmodifiableLocalAddresses;
    }

    @Override
    public final void setLocalAddresses(Iterable<SocketAddress> localAddresses) {
        if (localAddresses == null) {
            throw new NullPointerException("localAddresses");
        }
        ArrayList<SocketAddress> list = new ArrayList<SocketAddress>();
        for (SocketAddress a : localAddresses) {
            list.add(a);
        }
        this.setLocalAddresses(list.toArray(new SocketAddress[list.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setLocalAddresses(SocketAddress ... localAddresses) {
        if (localAddresses == null) {
            throw new NullPointerException("localAddresses");
        }
        Object object = this.bindLock;
        synchronized (object) {
            if (this.bound) {
                throw new IllegalStateException("localAddress can't be set while the acceptor is bound.");
            }
            ArrayList<SocketAddress> newLocalAddresses = new ArrayList<SocketAddress>();
            for (SocketAddress a : localAddresses) {
                if (a != null && !this.getTransportMetadata().getAddressType().isAssignableFrom(a.getClass())) {
                    throw new IllegalArgumentException("localAddress type: " + a.getClass().getSimpleName() + " (expected: " + this.getTransportMetadata().getAddressType().getSimpleName() + ")");
                }
                newLocalAddresses.add(a);
            }
            if (newLocalAddresses.isEmpty()) {
                throw new IllegalArgumentException("empty localAddresses");
            }
            this.localAddresses.clear();
            this.localAddresses.addAll(newLocalAddresses);
        }
    }

    @Override
    public final boolean isDisconnectOnUnbind() {
        return this.disconnectOnUnbind;
    }

    @Override
    public final void setDisconnectOnUnbind(boolean disconnectClientsOnUnbind) {
        this.disconnectOnUnbind = disconnectClientsOnUnbind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void bind() throws IOException {
        if (this.isDisposing()) {
            throw new IllegalStateException("Already disposed.");
        }
        Object object = this.bindLock;
        synchronized (object) {
            if (this.bound) {
                throw new IllegalStateException("Already bound to: " + this.getLocalAddresses());
            }
            if (this.getHandler() == null) {
                throw new IllegalStateException("handler is not set.");
            }
            if (this.localAddresses.isEmpty()) {
                throw new IllegalStateException("no local addresses were specified.");
            }
            try {
                this.bind0();
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeIoException("Failed to bind to: " + this.getLocalAddresses(), e);
            }
            this.bound = true;
        }
        this.getListeners().fireServiceActivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unbind() {
        Object object = this.bindLock;
        synchronized (object) {
            if (!this.bound) {
                return;
            }
            try {
                this.unbind0();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeIoException("Failed to unbind from: " + this.getLocalAddresses(), e);
            }
            this.bound = false;
        }
        this.getListeners().fireServiceDeactivated();
    }

    protected abstract void bind0() throws Exception;

    protected abstract void unbind0() throws Exception;

    public String toString() {
        TransportMetadata m = this.getTransportMetadata();
        return '(' + m.getProviderName() + ' ' + m.getName() + " acceptor: " + (this.isActive() ? "localAddress: " + this.getLocalAddresses() + ", managedSessionCount: " + this.getManagedSessionCount() : "not bound") + ')';
    }
}

