/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.net.SocketAddress;
import org.apache.mina.common.AbstractIoService;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportMetadata;

public abstract class AbstractIoConnector
extends AbstractIoService
implements IoConnector {
    private int connectTimeout = 60;
    private SocketAddress defaultRemoteAddress;

    protected AbstractIoConnector(IoSessionConfig sessionConfig) {
        super(sessionConfig);
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final long getConnectTimeoutMillis() {
        return (long)this.connectTimeout * 1000L;
    }

    public final void setConnectTimeout(int connectTimeout) {
        if (connectTimeout <= 0) {
            throw new IllegalArgumentException("connectTimeout: " + connectTimeout);
        }
        this.connectTimeout = connectTimeout;
    }

    public SocketAddress getDefaultRemoteAddress() {
        return this.defaultRemoteAddress;
    }

    public final void setDefaultRemoteAddress(SocketAddress defaultRemoteAddress) {
        if (defaultRemoteAddress == null) {
            throw new NullPointerException("defaultRemoteAddress");
        }
        if (!this.getTransportMetadata().getAddressType().isAssignableFrom(defaultRemoteAddress.getClass())) {
            throw new IllegalArgumentException("defaultRemoteAddress type: " + defaultRemoteAddress.getClass() + " (expected: " + this.getTransportMetadata().getAddressType() + ")");
        }
        this.defaultRemoteAddress = defaultRemoteAddress;
    }

    public final ConnectFuture connect() {
        SocketAddress defaultRemoteAddress = this.getDefaultRemoteAddress();
        if (defaultRemoteAddress == null) {
            throw new IllegalStateException("defaultRemoteAddress is not set.");
        }
        return this.connect(defaultRemoteAddress, null);
    }

    public final ConnectFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, null);
    }

    public final ConnectFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        if (this.isDisposing()) {
            throw new IllegalStateException("Already disposed.");
        }
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        if (!this.getTransportMetadata().getAddressType().isAssignableFrom(remoteAddress.getClass())) {
            throw new IllegalArgumentException("remoteAddress type: " + remoteAddress.getClass() + " (expected: " + this.getTransportMetadata().getAddressType() + ")");
        }
        if (localAddress != null && !this.getTransportMetadata().getAddressType().isAssignableFrom(localAddress.getClass())) {
            throw new IllegalArgumentException("localAddress type: " + localAddress.getClass() + " (expected: " + this.getTransportMetadata().getAddressType() + ")");
        }
        if (this.getHandler() == null) {
            if (this.getSessionConfig().isUseReadOperation()) {
                this.setHandler(new IoHandler(){

                    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                    }

                    public void messageReceived(IoSession session, Object message) throws Exception {
                    }

                    public void messageSent(IoSession session, Object message) throws Exception {
                    }

                    public void sessionClosed(IoSession session) throws Exception {
                    }

                    public void sessionCreated(IoSession session) throws Exception {
                    }

                    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
                    }

                    public void sessionOpened(IoSession session) throws Exception {
                    }
                });
            } else {
                throw new IllegalStateException("handler is not set.");
            }
        }
        return this.connect0(remoteAddress, localAddress);
    }

    protected abstract ConnectFuture connect0(SocketAddress var1, SocketAddress var2);

    protected final void finishSessionInitialization0(final IoSession session, IoFuture future) {
        future.addListener(new IoFutureListener<ConnectFuture>(){

            @Override
            public void operationComplete(ConnectFuture future) {
                if (future.isCanceled()) {
                    session.close();
                }
            }
        });
    }

    public String toString() {
        TransportMetadata m = this.getTransportMetadata();
        return '(' + m.getProviderName() + ' ' + m.getName() + " connector: " + "managedSessionCount: " + this.getManagedSessionCount() + ')';
    }
}

