/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.ConcurrentHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoServiceListenerSupport {
    private final IoService service;
    private final List<IoServiceListener> listeners = new CopyOnWriteArrayList<IoServiceListener>();
    private final Set<IoSession> managedSessions = new ConcurrentHashSet<IoSession>();
    private final Set<IoSession> readOnlyManagedSessions = Collections.unmodifiableSet(this.managedSessions);
    private final AtomicBoolean activated = new AtomicBoolean();
    private volatile long activationTime;
    private volatile int largestManagedSessionCount;
    private volatile long cumulativeManagedSessionCount;

    public IoServiceListenerSupport(IoService service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
    }

    public void add(IoServiceListener listener) {
        this.listeners.add(listener);
    }

    public void remove(IoServiceListener listener) {
        this.listeners.remove(listener);
    }

    public long getActivationTime() {
        return this.activationTime;
    }

    public Set<IoSession> getManagedSessions() {
        return this.readOnlyManagedSessions;
    }

    public int getManagedSessionCount() {
        return this.managedSessions.size();
    }

    public int getLargestManagedSessionCount() {
        return this.largestManagedSessionCount;
    }

    public long getCumulativeManagedSessionCount() {
        return this.cumulativeManagedSessionCount;
    }

    public boolean isActive() {
        return this.activated.get();
    }

    public void fireServiceActivated() {
        if (!this.activated.compareAndSet(false, true)) {
            return;
        }
        this.activationTime = System.currentTimeMillis();
        for (IoServiceListener l : this.listeners) {
            l.serviceActivated(this.service);
        }
    }

    public void fireServiceIdle(IdleStatus status) {
        if (!this.activated.get()) {
            return;
        }
        for (IoServiceListener l : this.listeners) {
            l.serviceIdle(this.service, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceDeactivated() {
        if (!this.activated.compareAndSet(true, false)) {
            return;
        }
        try {
            for (IoServiceListener l : this.listeners) {
                l.serviceDeactivated(this.service);
            }
        }
        finally {
            this.disconnectSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionCreated(IoSession session) {
        boolean firstSession = false;
        if (session.getService() instanceof IoConnector) {
            Set<IoSession> set = this.managedSessions;
            synchronized (set) {
                firstSession = this.managedSessions.isEmpty();
            }
        }
        if (!this.managedSessions.add(session)) {
            return;
        }
        if (firstSession) {
            this.fireServiceActivated();
        }
        session.getFilterChain().fireSessionCreated();
        session.getFilterChain().fireSessionOpened();
        int managedSessionCount = this.managedSessions.size();
        if (managedSessionCount > this.largestManagedSessionCount) {
            this.largestManagedSessionCount = managedSessionCount;
        }
        ++this.cumulativeManagedSessionCount;
        for (IoServiceListener l : this.listeners) {
            l.sessionCreated(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionDestroyed(IoSession session) {
        if (!this.managedSessions.remove(session)) {
            return;
        }
        session.getFilterChain().fireSessionClosed();
        try {
            for (IoServiceListener l : this.listeners) {
                l.sessionDestroyed(session);
            }
        }
        finally {
            if (session.getService() instanceof IoConnector) {
                boolean lastSession = false;
                Set<IoSession> set = this.managedSessions;
                synchronized (set) {
                    lastSession = this.managedSessions.isEmpty();
                }
                if (lastSession) {
                    this.fireServiceDeactivated();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSessions() {
        if (!(this.service instanceof IoAcceptor)) {
            return;
        }
        if (!((IoAcceptor)this.service).isDisconnectOnUnbind()) {
            return;
        }
        Object lock = new Object();
        LockNotifyingListener listener = new LockNotifyingListener(lock);
        for (IoSession s : this.managedSessions) {
            s.close().addListener(listener);
        }
        try {
            Object i$ = lock;
            synchronized (i$) {
                while (!this.managedSessions.isEmpty()) {
                    lock.wait(500L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LockNotifyingListener
    implements IoFutureListener<IoFuture> {
        private final Object lock;

        public LockNotifyingListener(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationComplete(IoFuture future) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

