/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.common.AttributeKey;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.UnderivableBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public abstract class CumulativeProtocolDecoder
extends ProtocolDecoderAdapter {
    private final AttributeKey BUFFER = new AttributeKey(this.getClass(), "buffer");

    protected CumulativeProtocolDecoder() {
    }

    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        boolean usingSessionBuffer = true;
        IoBuffer buf = (IoBuffer)session.getAttribute(this.BUFFER);
        if (buf != null) {
            buf.put(in);
            buf.flip();
        } else {
            buf = in;
            usingSessionBuffer = false;
        }
        do {
            int oldPos = buf.position();
            boolean decoded = this.doDecode(session, buf, out);
            if (!decoded) break;
            if (buf.position() != oldPos) continue;
            throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
        } while (buf.hasRemaining());
        if (buf.hasRemaining()) {
            if (usingSessionBuffer) {
                buf.compact();
            } else {
                this.storeRemainingInSession(buf, session);
            }
        } else if (usingSessionBuffer) {
            this.removeSessionBuffer(session);
        }
    }

    protected abstract boolean doDecode(IoSession var1, IoBuffer var2, ProtocolDecoderOutput var3) throws Exception;

    public void dispose(IoSession session) throws Exception {
        this.removeSessionBuffer(session);
    }

    private void removeSessionBuffer(IoSession session) {
        session.removeAttribute(this.BUFFER);
    }

    private void storeRemainingInSession(IoBuffer buf, IoSession session) {
        UnderivableBuffer remainingBuf = new UnderivableBuffer(IoBuffer.allocate(buf.capacity()).setAutoExpand(true));
        ((IoBuffer)remainingBuf).order(buf.order());
        ((IoBuffer)remainingBuf).put(buf);
        session.setAttribute(this.BUFFER, remainingBuf);
    }
}

