/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.statemachine;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecodingStateMachine
implements DecodingState {
    private final Logger log = LoggerFactory.getLogger(DecodingStateMachine.class);
    private final List<Object> childProducts = new ArrayList<Object>();
    private final ProtocolDecoderOutput childOutput = new ProtocolDecoderOutput(){

        public void flush() {
        }

        public void write(Object message) {
            DecodingStateMachine.this.childProducts.add(message);
        }
    };
    private DecodingState currentState;

    protected abstract DecodingState init() throws Exception;

    protected abstract DecodingState finishDecode(List<Object> var1, ProtocolDecoderOutput var2) throws Exception;

    protected abstract void destroy() throws Exception;

    @Override
    public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecodingState state = this.currentState;
        if (state == null) {
            state = this.init();
        }
        int limit = in.limit();
        int pos = in.position();
        try {
            DecodingState oldState;
            while (pos != limit) {
                oldState = state;
                if ((state = state.decode(in, this.childOutput)) == null) {
                    DecodingState decodingState = this.finishDecode(this.childProducts, out);
                    return decodingState;
                }
                int newPos = in.position();
                if (newPos == pos && oldState == state) break;
                pos = newPos;
            }
            oldState = this;
            return oldState;
        }
        catch (Exception e) {
            state = null;
            throw e;
        }
        finally {
            this.currentState = state;
            if (state == null) {
                this.childProducts.clear();
                try {
                    this.destroy();
                }
                catch (Exception e2) {
                    this.log.warn("Failed to destroy a decoding state machine.", (Throwable)e2);
                }
            }
        }
    }
}

