/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.statemachine;

import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.apache.mina.filter.codec.statemachine.DecodingStateMachine;

public class StateMachineProtocolDecoder
implements ProtocolDecoder {
    private final DecodingStateMachine stateMachine;
    private DecodingState currentState;

    public StateMachineProtocolDecoder(DecodingStateMachine stateMachine) {
        if (stateMachine == null) {
            throw new NullPointerException("stateMachine");
        }
        this.stateMachine = stateMachine;
    }

    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecodingState state = this.currentState;
        if (state == null) {
            state = this.stateMachine.init();
        }
        try {
            DecodingState oldState;
            int remaining;
            do {
                if ((remaining = in.remaining()) == 0) {
                } else {
                    oldState = state;
                    if ((state = state.decode(in, out)) != null) continue;
                }
                break;
            } while (in.remaining() != remaining || oldState != state);
        }
        catch (Exception e) {
            state = null;
            throw e;
        }
        finally {
            this.currentState = state;
        }
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

