/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.logging;

import java.util.Map;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoEventType;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.filter.logging.LogLevel;
import org.apache.mina.util.CopyOnWriteMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingFilter
extends IoFilterAdapter {
    private final Map<IoEventType, LogLevel> logSettings = new CopyOnWriteMap<IoEventType, LogLevel>();
    private final String name;

    public LoggingFilter() {
        this(LoggingFilter.class.getName());
    }

    public LoggingFilter(Class<?> clazz) {
        this(clazz.getName());
    }

    public LoggingFilter(String name) {
        this.name = name;
        this.setLogLevel(IoEventType.EXCEPTION_CAUGHT, LogLevel.WARN);
        this.setLogLevel(IoEventType.MESSAGE_RECEIVED, LogLevel.INFO);
        this.setLogLevel(IoEventType.MESSAGE_SENT, LogLevel.INFO);
        this.setLogLevel(IoEventType.SESSION_CLOSED, LogLevel.INFO);
        this.setLogLevel(IoEventType.SESSION_CREATED, LogLevel.INFO);
        this.setLogLevel(IoEventType.SESSION_IDLE, LogLevel.INFO);
        this.setLogLevel(IoEventType.SESSION_OPENED, LogLevel.INFO);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        this.getLogLevel(IoEventType.EXCEPTION_CAUGHT).log(session, this.name, "EXCEPTION: ", cause);
        nextFilter.exceptionCaught(session, cause);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.getLogLevel(IoEventType.MESSAGE_RECEIVED).log(session, this.name, "RECEIVED: " + message);
        nextFilter.messageReceived(session, message);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.getLogLevel(IoEventType.MESSAGE_SENT).log(session, this.name, "SENT: " + writeRequest.getMessage());
        nextFilter.messageSent(session, writeRequest);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.getLogLevel(IoEventType.SESSION_CLOSED).log(session, this.name, "CLOSED");
        nextFilter.sessionClosed(session);
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.getLogLevel(IoEventType.SESSION_CREATED).log(session, this.name, "CREATED");
        nextFilter.sessionCreated(session);
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        this.getLogLevel(IoEventType.SESSION_IDLE).log(session, this.name, "IDLE: " + status);
        nextFilter.sessionIdle(session, status);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.getLogLevel(IoEventType.SESSION_OPENED).log(session, this.name, "OPENED");
        nextFilter.sessionOpened(session);
    }

    public void setExceptionCaughtLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.EXCEPTION_CAUGHT, logLevel);
    }

    public void setMessageReceivedLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.MESSAGE_RECEIVED, logLevel);
    }

    public void setMessageSentLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.MESSAGE_SENT, logLevel);
    }

    public void setSessionClosedLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.SESSION_CLOSED, logLevel);
    }

    public void setSessionCreatedLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.SESSION_CREATED, logLevel);
    }

    public void setSessionIdleLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.SESSION_IDLE, logLevel);
    }

    public void setSessionOpenedLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.SESSION_OPENED, logLevel);
    }

    public void setLogLevel(IoEventType eventType, LogLevel logLevel) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        if (logLevel == null) {
            throw new NullPointerException("logLevel");
        }
        this.logSettings.put(eventType, logLevel);
    }

    public LogLevel getLogLevel(IoEventType eventType) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        return this.logSettings.get((Object)eventType);
    }

    public LogLevel getExceptionCaughtLogLevel() {
        return this.getLogLevel(IoEventType.EXCEPTION_CAUGHT);
    }

    public LogLevel getMessageReceivedLogLevel() {
        return this.getLogLevel(IoEventType.MESSAGE_RECEIVED);
    }

    public LogLevel getMessageSentLogLevel() {
        return this.getLogLevel(IoEventType.MESSAGE_SENT);
    }

    public LogLevel getSessionClosedLogLevel() {
        return this.getLogLevel(IoEventType.SESSION_CLOSED);
    }

    public LogLevel getSessionCreatedLogLevel() {
        return this.getLogLevel(IoEventType.SESSION_CREATED);
    }

    public LogLevel getSessionIdleLogLevel() {
        return this.getLogLevel(IoEventType.SESSION_IDLE);
    }

    public LogLevel getSessionOpenedLogLevel() {
        return this.getLogLevel(IoEventType.SESSION_OPENED);
    }
}

