/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import org.apache.mina.common.AttributeKey;
import org.apache.mina.common.DefaultWriteRequest;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.util.CircularQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamWriteFilter
extends IoFilterAdapter {
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 4096;
    public static final AttributeKey CURRENT_STREAM = new AttributeKey(StreamWriteFilter.class, "stream");
    static final AttributeKey WRITE_REQUEST_QUEUE = new AttributeKey(StreamWriteFilter.class, "queue");
    static final AttributeKey CURRENT_WRITE_REQUEST = new AttributeKey(StreamWriteFilter.class, "writeRequest");
    private int writeBufferSize = 4096;

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(StreamWriteFilter.class)) {
            throw new IllegalStateException("Only one " + StreamWriteFilter.class.getName() + " is permitted.");
        }
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (session.getAttribute(CURRENT_STREAM) != null) {
            Queue<WriteRequest> queue = this.getWriteRequestQueue(session);
            if (queue == null) {
                queue = new CircularQueue<WriteRequest>();
                session.setAttribute(WRITE_REQUEST_QUEUE, queue);
            }
            queue.add(writeRequest);
            return;
        }
        Object message = writeRequest.getMessage();
        if (message instanceof InputStream) {
            InputStream inputStream = (InputStream)message;
            IoBuffer buffer = this.getNextBuffer(inputStream);
            if (buffer == null) {
                writeRequest.getFuture().setWritten();
                nextFilter.messageSent(session, writeRequest);
            } else {
                session.setAttribute(CURRENT_STREAM, inputStream);
                session.setAttribute(CURRENT_WRITE_REQUEST, writeRequest);
                nextFilter.filterWrite(session, new DefaultWriteRequest(buffer));
            }
        } else {
            nextFilter.filterWrite(session, writeRequest);
        }
    }

    private Queue<WriteRequest> getWriteRequestQueue(IoSession session) {
        return (Queue)session.getAttribute(WRITE_REQUEST_QUEUE);
    }

    private Queue<WriteRequest> removeWriteRequestQueue(IoSession session) {
        return (Queue)session.removeAttribute(WRITE_REQUEST_QUEUE);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        InputStream inputStream = (InputStream)session.getAttribute(CURRENT_STREAM);
        if (inputStream == null) {
            nextFilter.messageSent(session, writeRequest);
        } else {
            IoBuffer buffer = this.getNextBuffer(inputStream);
            if (buffer == null) {
                session.removeAttribute(CURRENT_STREAM);
                WriteRequest currentWriteRequest = (WriteRequest)session.removeAttribute(CURRENT_WRITE_REQUEST);
                Queue<WriteRequest> queue = this.removeWriteRequestQueue(session);
                if (queue != null) {
                    WriteRequest wr = queue.poll();
                    while (wr != null) {
                        this.filterWrite(nextFilter, session, wr);
                        wr = queue.poll();
                    }
                }
                currentWriteRequest.getFuture().setWritten();
                nextFilter.messageSent(session, currentWriteRequest);
            } else {
                nextFilter.filterWrite(session, new DefaultWriteRequest(buffer));
            }
        }
    }

    private IoBuffer getNextBuffer(InputStream is) throws IOException {
        int off;
        byte[] bytes = new byte[this.writeBufferSize];
        int n = 0;
        for (off = 0; off < bytes.length && (n = is.read(bytes, off, bytes.length - off)) != -1; off += n) {
        }
        if (n == -1 && off == 0) {
            return null;
        }
        IoBuffer buffer = IoBuffer.wrap(bytes, 0, off);
        return buffer;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        if (writeBufferSize < 1) {
            throw new IllegalArgumentException("writeBufferSize must be at least 1");
        }
        this.writeBufferSize = writeBufferSize;
    }
}

