/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.demux;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.UnknownMessageTypeException;
import org.apache.mina.handler.demux.ExceptionHandler;
import org.apache.mina.handler.demux.MessageHandler;
import org.apache.mina.util.IdentityHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemuxingIoHandler
extends IoHandlerAdapter {
    private final Map<Class<?>, MessageHandler<?>> messageHandlerCache = new ConcurrentHashMap();
    private final Map<Class<?>, MessageHandler<?>> messageHandlers = new ConcurrentHashMap();
    private final Map<Class<?>, ExceptionHandler<?>> exceptionHandlerCache = new ConcurrentHashMap();
    private final Map<Class<?>, ExceptionHandler<?>> exceptionHandlers = new ConcurrentHashMap();

    public <E> MessageHandler<? super E> addMessageHandler(Class<E> type, MessageHandler<? super E> handler) {
        this.messageHandlerCache.clear();
        return this.messageHandlers.put(type, handler);
    }

    public <E> MessageHandler<? super E> removeMessageHandler(Class<E> type) {
        this.messageHandlerCache.clear();
        return this.messageHandlers.remove(type);
    }

    public <E extends Throwable> ExceptionHandler<? super E> addExceptionHandler(Class<E> type, ExceptionHandler<? super E> handler) {
        this.exceptionHandlerCache.clear();
        return this.exceptionHandlers.put(type, handler);
    }

    public <E extends Throwable> ExceptionHandler<? super E> removeExceptionHandler(Class<E> type) {
        this.exceptionHandlerCache.clear();
        return this.exceptionHandlers.remove(type);
    }

    public <E> MessageHandler<? super E> getMessageHandler(Class<E> type) {
        return this.messageHandlers.get(type);
    }

    public Map<Class<?>, MessageHandler<?>> getMessageHandlerMap() {
        return Collections.unmodifiableMap(this.messageHandlers);
    }

    public Map<Class<?>, ExceptionHandler<?>> getExceptionHandlerMap() {
        return Collections.unmodifiableMap(this.exceptionHandlers);
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        MessageHandler<Object> handler = this.findMessageHandler(message.getClass());
        if (handler == null) {
            throw new UnknownMessageTypeException("No message handler found for message: " + message);
        }
        handler.messageReceived(session, message);
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
        MessageHandler<Object> handler = this.findMessageHandler(message.getClass());
        if (handler == null) {
            throw new UnknownMessageTypeException("No handler found for message: " + message.getClass().getName());
        }
        handler.messageSent(session, message);
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        ExceptionHandler<Throwable> handler = this.findExceptionHandler(cause.getClass());
        if (handler == null) {
            throw new UnknownMessageTypeException("No handler found for exception: " + cause.getClass().getName());
        }
        handler.exceptionCaught(session, cause);
    }

    protected MessageHandler<Object> findMessageHandler(Class<?> type) {
        return this.findMessageHandler(type, null);
    }

    protected ExceptionHandler<Throwable> findExceptionHandler(Class<? extends Throwable> type) {
        return this.findExceptionHandler(type, null);
    }

    private MessageHandler<Object> findMessageHandler(Class type, Set<Class> triedClasses) {
        return (MessageHandler)this.findHandler(this.messageHandlers, this.messageHandlerCache, type, triedClasses);
    }

    private ExceptionHandler<Throwable> findExceptionHandler(Class type, Set<Class> triedClasses) {
        return (ExceptionHandler)this.findHandler(this.exceptionHandlers, this.exceptionHandlerCache, type, triedClasses);
    }

    private Object findHandler(Map handlers, Map handlerCache, Class type, Set<Class> triedClasses) {
        Class superclass;
        Object handler = null;
        if (triedClasses != null && triedClasses.contains(type)) {
            return null;
        }
        handler = handlerCache.get(type);
        if (handler != null) {
            return handler;
        }
        handler = handlers.get(type);
        if (handler == null) {
            Class<?> element;
            Class<?>[] interfaces;
            if (triedClasses == null) {
                triedClasses = new IdentityHashSet<Class>();
            }
            triedClasses.add(type);
            Class<?>[] arr$ = interfaces = type.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (handler = this.findHandler(handlers, handlerCache, element = arr$[i$], triedClasses)) == null; ++i$) {
            }
        }
        if (handler == null && (superclass = type.getSuperclass()) != null) {
            handler = this.findHandler(handlers, handlerCache, superclass, null);
        }
        if (handler != null) {
            handlerCache.put(type, handler);
        }
        return handler;
    }
}

