/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.apache.mina.common.AbstractPollingConnectionlessIoAcceptor;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoProcessor;
import org.apache.mina.common.TransportMetadata;
import org.apache.mina.transport.socket.DatagramAcceptor;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.DefaultDatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramSession;
import org.apache.mina.transport.socket.nio.NioSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioDatagramAcceptor
extends AbstractPollingConnectionlessIoAcceptor<NioSession, DatagramChannel>
implements DatagramAcceptor {
    private volatile Selector selector;

    public NioDatagramAcceptor() {
        super(new DefaultDatagramSessionConfig());
    }

    public NioDatagramAcceptor(Executor executor) {
        super(new DefaultDatagramSessionConfig(), executor);
    }

    @Override
    protected void init() throws Exception {
        this.selector = Selector.open();
    }

    @Override
    protected void destroy() throws Exception {
        if (this.selector != null) {
            this.selector.close();
        }
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return NioDatagramSession.METADATA;
    }

    @Override
    public DatagramSessionConfig getSessionConfig() {
        return (DatagramSessionConfig)super.getSessionConfig();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)super.getLocalAddress();
    }

    @Override
    public void setLocalAddress(InetSocketAddress localAddress) {
        this.setLocalAddress((SocketAddress)localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DatagramChannel bind(SocketAddress localAddress) throws Exception {
        DatagramChannel c = DatagramChannel.open();
        boolean success = false;
        try {
            DatagramSessionConfig cfg = this.getSessionConfig();
            c.socket().setReuseAddress(cfg.isReuseAddress());
            c.socket().setBroadcast(cfg.isBroadcast());
            c.socket().setReceiveBufferSize(cfg.getReceiveBufferSize());
            c.socket().setSendBufferSize(cfg.getSendBufferSize());
            if (c.socket().getTrafficClass() != cfg.getTrafficClass()) {
                c.socket().setTrafficClass(cfg.getTrafficClass());
            }
            c.configureBlocking(false);
            c.socket().bind(localAddress);
            c.register(this.selector, 1);
            success = true;
        }
        finally {
            if (!success) {
                this.unbind(c);
            }
        }
        return c;
    }

    @Override
    protected boolean isReadable(DatagramChannel handle) {
        SelectionKey key = handle.keyFor(this.selector);
        if (key == null) {
            return false;
        }
        if (!key.isValid()) {
            return false;
        }
        return key.isReadable();
    }

    @Override
    protected boolean isWritable(DatagramChannel handle) {
        SelectionKey key = handle.keyFor(this.selector);
        if (key == null) {
            return false;
        }
        if (!key.isValid()) {
            return false;
        }
        return key.isWritable();
    }

    @Override
    protected SocketAddress localAddress(DatagramChannel handle) throws Exception {
        return handle.socket().getLocalSocketAddress();
    }

    @Override
    protected NioSession newSession(IoProcessor<NioSession> processor, DatagramChannel handle, SocketAddress remoteAddress) {
        SelectionKey key = handle.keyFor(this.selector);
        if (key == null) {
            return null;
        }
        NioDatagramSession newSession = new NioDatagramSession(this, handle, processor, remoteAddress);
        newSession.setSelectionKey(key);
        return newSession;
    }

    @Override
    protected SocketAddress receive(DatagramChannel handle, IoBuffer buffer) throws Exception {
        return handle.receive(buffer.buf());
    }

    @Override
    protected boolean select(int timeout) throws Exception {
        return this.selector.select(timeout) > 0;
    }

    @Override
    protected Iterator<DatagramChannel> selectedHandles() {
        return new DatagramChannelIterator(this.selector.selectedKeys());
    }

    @Override
    protected int send(NioSession session, IoBuffer buffer, SocketAddress remoteAddress) throws Exception {
        return ((DatagramChannel)session.getChannel()).send(buffer.buf(), remoteAddress);
    }

    @Override
    protected void setInterestedInWrite(NioSession session, boolean interested) throws Exception {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            return;
        }
        if (interested) {
            key.interestOps(key.interestOps() | 4);
        } else {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
        }
    }

    @Override
    protected void unbind(DatagramChannel handle) throws Exception {
        SelectionKey key = handle.keyFor(this.selector);
        if (key != null) {
            key.cancel();
        }
        handle.disconnect();
        handle.close();
    }

    @Override
    protected void wakeup() {
        this.selector.wakeup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatagramChannelIterator
    implements Iterator<DatagramChannel> {
        private final Iterator<SelectionKey> i;

        private DatagramChannelIterator(Collection<SelectionKey> keys) {
            this.i = keys.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public DatagramChannel next() {
            return (DatagramChannel)this.i.next().channel();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }
}

