/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.Iterator;
import org.apache.mina.common.AbstractPollingIoConnector;
import org.apache.mina.common.IoProcessor;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportMetadata;
import org.apache.mina.transport.socket.DatagramConnector;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.DefaultDatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramSession;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioDatagramConnector
extends AbstractPollingIoConnector<NioSession, DatagramChannel>
implements DatagramConnector {
    public NioDatagramConnector() {
        super((IoSessionConfig)new DefaultDatagramSessionConfig(), NioProcessor.class);
    }

    public NioDatagramConnector(int processorCount) {
        super((IoSessionConfig)new DefaultDatagramSessionConfig(), NioProcessor.class, processorCount);
    }

    public NioDatagramConnector(IoProcessor<NioSession> processor) {
        super((IoSessionConfig)new DefaultDatagramSessionConfig(), processor);
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return NioDatagramSession.METADATA;
    }

    @Override
    public DatagramSessionConfig getSessionConfig() {
        return (DatagramSessionConfig)super.getSessionConfig();
    }

    @Override
    public InetSocketAddress getDefaultRemoteAddress() {
        return (InetSocketAddress)super.getDefaultRemoteAddress();
    }

    @Override
    public void setDefaultRemoteAddress(InetSocketAddress defaultRemoteAddress) {
        super.setDefaultRemoteAddress(defaultRemoteAddress);
    }

    @Override
    protected void init() throws Exception {
    }

    @Override
    protected DatagramChannel newHandle(SocketAddress localAddress) throws Exception {
        DatagramChannel ch = DatagramChannel.open();
        ch.socket().setReuseAddress(this.getSessionConfig().isReuseAddress());
        ch.socket().setReuseAddress(true);
        ch.socket().setBroadcast(this.getSessionConfig().isBroadcast());
        if (localAddress != null) {
            ch.socket().bind(localAddress);
        }
        return ch;
    }

    @Override
    protected boolean connect(DatagramChannel handle, SocketAddress remoteAddress) throws Exception {
        handle.connect(remoteAddress);
        return true;
    }

    @Override
    protected NioSession newSession(IoProcessor<NioSession> processor, DatagramChannel handle) {
        return new NioDatagramSession(this, handle, processor);
    }

    @Override
    protected void close(DatagramChannel handle) throws Exception {
        handle.disconnect();
        handle.close();
    }

    @Override
    protected Iterator<DatagramChannel> allHandles() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    protected AbstractPollingIoConnector.ConnectionRequest connectionRequest(DatagramChannel handle) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void destroy() throws Exception {
    }

    @Override
    protected void finishConnect(DatagramChannel handle) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void register(DatagramChannel handle, AbstractPollingIoConnector.ConnectionRequest request) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean select(int timeout) throws Exception {
        return false;
    }

    @Override
    protected Iterator<DatagramChannel> selectedHandles() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    protected void wakeup() {
    }
}

