/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.mina.common.DefaultIoFilterChain;
import org.apache.mina.common.DefaultTransportMetadata;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoProcessor;
import org.apache.mina.common.IoService;
import org.apache.mina.common.RuntimeIoException;
import org.apache.mina.common.TransportMetadata;
import org.apache.mina.transport.socket.AbstractDatagramSessionConfig;
import org.apache.mina.transport.socket.DatagramSession;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.DefaultDatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioDatagramSession
extends NioSession
implements DatagramSession {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("nio", "datagram", true, false, InetSocketAddress.class, DatagramSessionConfig.class, IoBuffer.class);
    private final IoService service;
    private final DatagramSessionConfig config = new SessionConfigImpl();
    private final IoFilterChain filterChain = new DefaultIoFilterChain(this);
    private final DatagramChannel ch;
    private final IoHandler handler;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;
    private final IoProcessor<NioSession> processor;
    private SelectionKey key;

    NioDatagramSession(IoService service, DatagramChannel ch, IoProcessor<NioSession> processor, SocketAddress remoteAddress) {
        this.service = service;
        this.ch = ch;
        this.handler = service.getHandler();
        this.processor = processor;
        this.remoteAddress = (InetSocketAddress)remoteAddress;
        this.localAddress = (InetSocketAddress)ch.socket().getLocalSocketAddress();
        this.config.setAll(service.getSessionConfig());
    }

    NioDatagramSession(IoService service, DatagramChannel ch, IoProcessor<NioSession> processor) {
        this(service, ch, processor, ch.socket().getRemoteSocketAddress());
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    @Override
    protected IoProcessor<NioSession> getProcessor() {
        return this.processor;
    }

    @Override
    public DatagramSessionConfig getConfig() {
        return this.config;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    DatagramChannel getChannel() {
        return this.ch;
    }

    @Override
    SelectionKey getSelectionKey() {
        return this.key;
    }

    @Override
    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public InetSocketAddress getServiceAddress() {
        return (InetSocketAddress)super.getServiceAddress();
    }

    private class SessionConfigImpl
    extends AbstractDatagramSessionConfig {
        private SessionConfigImpl() {
        }

        public int getReceiveBufferSize() {
            try {
                return NioDatagramSession.this.ch.socket().getReceiveBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setReceiveBufferSize(int receiveBufferSize) {
            if (DefaultDatagramSessionConfig.isSetReceiveBufferSizeAvailable()) {
                try {
                    NioDatagramSession.this.ch.socket().setReceiveBufferSize(receiveBufferSize);
                    receiveBufferSize = NioDatagramSession.this.ch.socket().getReceiveBufferSize();
                }
                catch (SocketException e) {
                    throw new RuntimeIoException(e);
                }
            }
        }

        public boolean isBroadcast() {
            try {
                return NioDatagramSession.this.ch.socket().getBroadcast();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setBroadcast(boolean broadcast) {
            try {
                NioDatagramSession.this.ch.socket().setBroadcast(broadcast);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public int getSendBufferSize() {
            try {
                return NioDatagramSession.this.ch.socket().getSendBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setSendBufferSize(int sendBufferSize) {
            if (DefaultDatagramSessionConfig.isSetSendBufferSizeAvailable()) {
                try {
                    NioDatagramSession.this.ch.socket().setSendBufferSize(sendBufferSize);
                }
                catch (SocketException e) {
                    throw new RuntimeIoException(e);
                }
            }
        }

        public boolean isReuseAddress() {
            try {
                return NioDatagramSession.this.ch.socket().getReuseAddress();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setReuseAddress(boolean reuseAddress) {
            try {
                NioDatagramSession.this.ch.socket().setReuseAddress(reuseAddress);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public int getTrafficClass() {
            if (DefaultDatagramSessionConfig.isGetTrafficClassAvailable()) {
                try {
                    return NioDatagramSession.this.ch.socket().getTrafficClass();
                }
                catch (SocketException e) {
                    throw new RuntimeIoException(e);
                }
            }
            return 0;
        }

        public void setTrafficClass(int trafficClass) {
            if (DefaultDatagramSessionConfig.isSetTrafficClassAvailable()) {
                try {
                    NioDatagramSession.this.ch.socket().setTrafficClass(trafficClass);
                }
                catch (SocketException e) {
                    throw new RuntimeIoException(e);
                }
            }
        }
    }
}

