/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.AbstractIoAcceptor;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TransportMetadata;
import org.apache.mina.transport.vmpipe.DefaultVmPipeSessionConfig;
import org.apache.mina.transport.vmpipe.VmPipe;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeSessionConfig;
import org.apache.mina.transport.vmpipe.VmPipeSessionImpl;

public final class VmPipeAcceptor
extends AbstractIoAcceptor {
    static final Map<VmPipeAddress, VmPipe> boundHandlers = new HashMap<VmPipeAddress, VmPipe>();

    public VmPipeAcceptor() {
        super(new DefaultVmPipeSessionConfig());
    }

    public TransportMetadata getTransportMetadata() {
        return VmPipeSessionImpl.METADATA;
    }

    public VmPipeSessionConfig getSessionConfig() {
        return (VmPipeSessionConfig)super.getSessionConfig();
    }

    public VmPipeAddress getLocalAddress() {
        return (VmPipeAddress)super.getLocalAddress();
    }

    public void setLocalAddress(VmPipeAddress localAddress) {
        super.setLocalAddress(localAddress);
    }

    protected IoFuture dispose0() throws Exception {
        this.unbind();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind0() throws IOException {
        List<SocketAddress> localAddresses = this.getLocalAddresses();
        ArrayList<SocketAddress> newLocalAddresses = new ArrayList<SocketAddress>();
        Map<VmPipeAddress, VmPipe> map = boundHandlers;
        synchronized (map) {
            VmPipeAddress localAddress;
            for (SocketAddress a : localAddresses) {
                localAddress = (VmPipeAddress)a;
                if (localAddress == null || localAddress.getPort() == 0) {
                    localAddress = null;
                    for (int i = 10000; i < Integer.MAX_VALUE; ++i) {
                        VmPipeAddress newLocalAddress = new VmPipeAddress(i);
                        if (boundHandlers.containsKey(newLocalAddress) || newLocalAddresses.contains(newLocalAddress)) continue;
                        localAddress = newLocalAddress;
                        break;
                    }
                    if (localAddress == null) {
                        throw new IOException("No port available.");
                    }
                } else {
                    if (localAddress.getPort() < 0) {
                        throw new IOException("Bind port number must be 0 or above.");
                    }
                    if (boundHandlers.containsKey(localAddress)) {
                        throw new IOException("Address already bound: " + localAddress);
                    }
                }
                newLocalAddresses.add(localAddress);
            }
            for (SocketAddress a : newLocalAddresses) {
                localAddress = (VmPipeAddress)a;
                if (!boundHandlers.containsKey(localAddress)) {
                    boundHandlers.put(localAddress, new VmPipe(this, localAddress, this.getHandler(), this.getListeners()));
                    continue;
                }
                for (SocketAddress a2 : newLocalAddresses) {
                    boundHandlers.remove(a2);
                }
                throw new IOException("Duplicate local address: " + a);
            }
        }
        this.setLocalAddresses(newLocalAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbind0() {
        Map<VmPipeAddress, VmPipe> map = boundHandlers;
        synchronized (map) {
            boundHandlers.remove(this.getLocalAddress());
        }
        this.getListeners().fireServiceDeactivated();
    }

    public IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        throw new UnsupportedOperationException();
    }

    void doFinishSessionInitialization(IoSession session, IoFuture future) {
        this.finishSessionInitialization(session, future);
    }
}

