/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.AbstractIoConnector;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.DefaultConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IdleStatusChecker;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.TransportMetadata;
import org.apache.mina.transport.vmpipe.DefaultVmPipeSessionConfig;
import org.apache.mina.transport.vmpipe.VmPipe;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeFilterChain;
import org.apache.mina.transport.vmpipe.VmPipeSessionConfig;
import org.apache.mina.transport.vmpipe.VmPipeSessionImpl;

public final class VmPipeConnector
extends AbstractIoConnector {
    private static final Set<VmPipeAddress> TAKEN_LOCAL_ADDRESSES = new HashSet<VmPipeAddress>();
    private static int nextLocalPort = -1;
    private static final IoFutureListener<IoFuture> LOCAL_ADDRESS_RECLAIMER = new LocalAddressReclaimer();

    public VmPipeConnector() {
        super(new DefaultVmPipeSessionConfig());
    }

    public TransportMetadata getTransportMetadata() {
        return VmPipeSessionImpl.METADATA;
    }

    public VmPipeSessionConfig getSessionConfig() {
        return (VmPipeSessionConfig)super.getSessionConfig();
    }

    protected ConnectFuture connect0(SocketAddress remoteAddress, SocketAddress localAddress) {
        VmPipeAddress actualLocalAddress;
        VmPipe entry = VmPipeAcceptor.boundHandlers.get(remoteAddress);
        if (entry == null) {
            return DefaultConnectFuture.newFailedFuture(new IOException("Endpoint unavailable: " + remoteAddress));
        }
        DefaultConnectFuture future = new DefaultConnectFuture();
        try {
            actualLocalAddress = VmPipeConnector.nextLocalAddress();
        }
        catch (IOException e) {
            return DefaultConnectFuture.newFailedFuture(e);
        }
        VmPipeSessionImpl localSession = new VmPipeSessionImpl(this, this.getListeners(), actualLocalAddress, this.getHandler(), entry);
        this.finishSessionInitialization(localSession, future);
        localSession.getCloseFuture().addListener(LOCAL_ADDRESS_RECLAIMER);
        try {
            IoFilterChain filterChain = localSession.getFilterChain();
            this.getFilterChainBuilder().buildFilterChain(filterChain);
            this.getListeners().fireSessionCreated(localSession);
            IdleStatusChecker.getInstance().addSession(localSession);
        }
        catch (Throwable t) {
            future.setException(t);
            return future;
        }
        VmPipeSessionImpl remoteSession = localSession.getRemoteSession();
        ((VmPipeAcceptor)remoteSession.getService()).doFinishSessionInitialization(remoteSession, null);
        try {
            IoFilterChain filterChain = remoteSession.getFilterChain();
            entry.getAcceptor().getFilterChainBuilder().buildFilterChain(filterChain);
            entry.getListeners().fireSessionCreated(remoteSession);
            IdleStatusChecker.getInstance().addSession(remoteSession);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
            remoteSession.close();
        }
        ((VmPipeFilterChain)localSession.getFilterChain()).start();
        ((VmPipeFilterChain)remoteSession.getFilterChain()).start();
        return future;
    }

    protected IoFuture dispose0() throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VmPipeAddress nextLocalAddress() throws IOException {
        Set<VmPipeAddress> set = TAKEN_LOCAL_ADDRESSES;
        synchronized (set) {
            if (nextLocalPort >= 0) {
                nextLocalPort = -1;
            }
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                VmPipeAddress answer;
                if (TAKEN_LOCAL_ADDRESSES.contains(answer = new VmPipeAddress(nextLocalPort--))) continue;
                TAKEN_LOCAL_ADDRESSES.add(answer);
                return answer;
            }
        }
        throw new IOException("Can't assign a local VM pipe port.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalAddressReclaimer
    implements IoFutureListener<IoFuture> {
        private LocalAddressReclaimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationComplete(IoFuture future) {
            Set set = TAKEN_LOCAL_ADDRESSES;
            synchronized (set) {
                TAKEN_LOCAL_ADDRESSES.remove(future.getSession().getLocalAddress());
            }
        }
    }
}

