/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.mina.common;

/**
 * An {@link IoBufferWrapper} that prohibits derivation of the buffer.
 * It is useful when you want expose your internal buffer which must be
 * auto-expandable all the time.
 * 
 * @author The Apache MINA Project (dev@mina.apache.org)
 * @version $Rev: 594006 $, $Date: 2007-11-12 11:16:49 +0900 (월, 12 11월 2007) $
 */
public class UnderivableBuffer extends IoBufferWrapper {

    public UnderivableBuffer(IoBuffer buf) {
        super(buf);
        if (buf.isDerived()) {
            throw new IllegalArgumentException("Derived buffer is not allowed.");
        }
    }

    @Override
    public IoBuffer asReadOnlyBuffer() {
        throw new UnsupportedOperationException("Buffer derivation disabled.");
    }

    @Override
    public IoBuffer duplicate() {
        throw new UnsupportedOperationException("Buffer derivation disabled.");
    }

    @Override
    public IoBuffer slice() {
        throw new UnsupportedOperationException("Buffer derivation disabled.");
    }
}
