/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.AbstractIoConnector;
import org.apache.mina.common.AbstractIoService;
import org.apache.mina.common.AbstractIoSession;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.DefaultConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoProcessor;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIoException;
import org.apache.mina.common.SimpleIoProcessorPool;
import org.apache.mina.util.NamePreservingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingIoConnector<T extends AbstractIoSession, H>
extends AbstractIoConnector {
    private static final AtomicInteger id = new AtomicInteger();
    private final Object lock = new Object();
    private final String threadName;
    private final Executor executor;
    private final boolean createdExecutor;
    private final Queue<ConnectionRequest> connectQueue = new ConcurrentLinkedQueue<ConnectionRequest>();
    private final Queue<ConnectionRequest> cancelQueue = new ConcurrentLinkedQueue<ConnectionRequest>();
    private final IoProcessor<T> processor;
    private final boolean createdProcessor;
    private final AbstractIoService.ServiceOperationFuture disposalFuture = new AbstractIoService.ServiceOperationFuture();
    private volatile boolean selectable;
    private Worker worker;

    protected AbstractPollingIoConnector(IoSessionConfig sessionConfig, Class<? extends IoProcessor<T>> processorClass) {
        this(sessionConfig, null, new SimpleIoProcessorPool(processorClass), true);
    }

    protected AbstractPollingIoConnector(IoSessionConfig sessionConfig, Class<? extends IoProcessor<T>> processorClass, int processorCount) {
        this(sessionConfig, null, new SimpleIoProcessorPool(processorClass, processorCount), true);
    }

    protected AbstractPollingIoConnector(IoSessionConfig sessionConfig, IoProcessor<T> processor) {
        this(sessionConfig, null, processor, false);
    }

    protected AbstractPollingIoConnector(IoSessionConfig sessionConfig, Executor executor, IoProcessor<T> processor) {
        this(sessionConfig, executor, processor, false);
    }

    private AbstractPollingIoConnector(IoSessionConfig sessionConfig, Executor executor, IoProcessor<T> processor, boolean createdProcessor) {
        super(sessionConfig);
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        if (executor == null) {
            this.executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            this.createdExecutor = true;
        } else {
            this.executor = executor;
            this.createdExecutor = false;
        }
        this.threadName = this.getClass().getSimpleName() + '-' + id.incrementAndGet();
        this.processor = processor;
        this.createdProcessor = createdProcessor;
        try {
            this.init();
            this.selectable = true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeIoException("Failed to initialize.", e);
        }
        finally {
            if (!this.selectable) {
                try {
                    this.destroy();
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
    }

    protected abstract void init() throws Exception;

    protected abstract void destroy() throws Exception;

    protected abstract H newHandle(SocketAddress var1) throws Exception;

    protected abstract boolean connect(H var1, SocketAddress var2) throws Exception;

    protected abstract boolean finishConnect(H var1) throws Exception;

    protected abstract T newSession(IoProcessor<T> var1, H var2) throws Exception;

    protected abstract void close(H var1) throws Exception;

    protected abstract void wakeup();

    protected abstract boolean select(int var1) throws Exception;

    protected abstract Iterator<H> selectedHandles();

    protected abstract Iterator<H> allHandles();

    protected abstract void register(H var1, ConnectionRequest var2) throws Exception;

    protected abstract ConnectionRequest connectionRequest(H var1);

    @Override
    protected final IoFuture dispose0() throws Exception {
        block3: {
            if (!this.disposalFuture.isDone()) {
                try {
                    this.startupWorker();
                    this.wakeup();
                }
                catch (RejectedExecutionException e) {
                    if (this.createdExecutor) break block3;
                    throw e;
                }
            }
        }
        return this.disposalFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final ConnectFuture connect0(SocketAddress remoteAddress, SocketAddress localAddress) {
        H handle = null;
        boolean success = false;
        try {
            handle = this.newHandle(localAddress);
            if (this.connect(handle, remoteAddress)) {
                DefaultConnectFuture future = new DefaultConnectFuture();
                T session = this.newSession(this.processor, handle);
                this.finishSessionInitialization((IoSession)session, future);
                ((AbstractIoSession)session).getProcessor().add(session);
                success = true;
                DefaultConnectFuture defaultConnectFuture = future;
                return defaultConnectFuture;
            }
            success = true;
        }
        catch (Exception e) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(e);
            return connectFuture;
        }
        finally {
            if (!success && handle != null) {
                try {
                    this.close(handle);
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        ConnectionRequest request = new ConnectionRequest(handle);
        this.connectQueue.add(request);
        this.startupWorker();
        this.wakeup();
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() {
        if (!this.selectable) {
            this.connectQueue.clear();
            this.cancelQueue.clear();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker, this.threadName));
            }
        }
    }

    private int registerNew() {
        ConnectionRequest req;
        int nHandles = 0;
        while ((req = this.connectQueue.poll()) != null) {
            Object handle = req.handle;
            try {
                this.register(handle, req);
                ++nHandles;
            }
            catch (Exception e) {
                req.setException(e);
                try {
                    this.close(handle);
                }
                catch (Exception e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
            }
        }
        return nHandles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cancelKeys() {
        ConnectionRequest req;
        int nHandles = 0;
        while ((req = this.cancelQueue.poll()) != null) {
            Object handle = req.handle;
            try {
                this.close(handle);
            }
            catch (Exception e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
            finally {
                ++nHandles;
            }
        }
        return nHandles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processSessions(Iterator<H> handlers) {
        int nHandles = 0;
        while (handlers.hasNext()) {
            H handle = handlers.next();
            handlers.remove();
            ConnectionRequest entry = this.connectionRequest(handle);
            boolean success = false;
            try {
                if (this.finishConnect(handle)) {
                    T session = this.newSession(this.processor, handle);
                    this.finishSessionInitialization((IoSession)session, entry);
                    ((AbstractIoSession)session).getProcessor().add(session);
                    ++nHandles;
                }
                success = true;
            }
            catch (Throwable e) {
                entry.setException(e);
            }
            finally {
                if (success) continue;
                this.cancelQueue.offer(entry);
            }
        }
        return nHandles;
    }

    private void processTimedOutSessions(Iterator<H> handles) {
        long currentTime = System.currentTimeMillis();
        while (handles.hasNext()) {
            H handle = handles.next();
            ConnectionRequest entry = this.connectionRequest(handle);
            if (currentTime < entry.deadline) continue;
            entry.setException(new ConnectException("Connection timed out."));
            this.cancelQueue.offer(entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ConnectionRequest
    extends DefaultConnectFuture {
        private final H handle;
        private final long deadline;

        public ConnectionRequest(H handle) {
            this.handle = handle;
            long timeout = AbstractPollingIoConnector.this.getConnectTimeoutMillis();
            this.deadline = timeout <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
        }

        public H getHandle() {
            return this.handle;
        }

        public long getDeadline() {
            return this.deadline;
        }

        @Override
        public void cancel() {
            super.cancel();
            AbstractPollingIoConnector.this.cancelQueue.add(this);
            AbstractPollingIoConnector.this.startupWorker();
            AbstractPollingIoConnector.this.wakeup();
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int nHandles = 0;
            while (AbstractPollingIoConnector.this.selectable) {
                try {
                    boolean selected = AbstractPollingIoConnector.this.select(1000);
                    nHandles += AbstractPollingIoConnector.this.registerNew();
                    if (selected) {
                        nHandles -= AbstractPollingIoConnector.this.processSessions(AbstractPollingIoConnector.this.selectedHandles());
                    }
                    AbstractPollingIoConnector.this.processTimedOutSessions(AbstractPollingIoConnector.this.allHandles());
                    if ((nHandles -= AbstractPollingIoConnector.this.cancelKeys()) != 0) continue;
                    Object object = AbstractPollingIoConnector.this.lock;
                    synchronized (object) {
                        if (AbstractPollingIoConnector.this.connectQueue.isEmpty()) {
                            AbstractPollingIoConnector.this.worker = null;
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                }
            }
            if (!AbstractPollingIoConnector.this.selectable) return;
            if (!AbstractPollingIoConnector.this.isDisposing()) return;
            AbstractPollingIoConnector.this.selectable = false;
            try {
                if (!AbstractPollingIoConnector.this.createdProcessor) return;
                AbstractPollingIoConnector.this.processor.dispose();
                return;
            }
            finally {
                try {
                    AbstractPollingIoConnector.this.destroy();
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                finally {
                    AbstractPollingIoConnector.this.disposalFuture.setDone();
                    if (AbstractPollingIoConnector.this.createdExecutor) {
                        ((ExecutorService)AbstractPollingIoConnector.this.executor).shutdown();
                    }
                }
            }
        }
    }
}

