/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.AbstractIoService;
import org.apache.mina.common.AbstractIoSession;
import org.apache.mina.common.DefaultIoFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.FileRegion;
import org.apache.mina.common.IdleStatusChecker;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoProcessor;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.common.WriteRequestQueue;
import org.apache.mina.common.WriteToClosedSessionException;
import org.apache.mina.util.CopyOnWriteMap;
import org.apache.mina.util.NamePreservingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingIoProcessor<T extends AbstractIoSession>
implements IoProcessor<T> {
    private static final int WRITE_SPIN_COUNT = 256;
    private static final Map<Class<?>, AtomicInteger> threadIds = new CopyOnWriteMap();
    private final Object lock = new Object();
    private final String threadName;
    private final Executor executor;
    private final Queue<T> newSessions = new ConcurrentLinkedQueue<T>();
    private final Queue<T> removingSessions = new ConcurrentLinkedQueue<T>();
    private final Queue<T> flushingSessions = new ConcurrentLinkedQueue<T>();
    private final Queue<T> trafficControllingSessions = new ConcurrentLinkedQueue<T>();
    private Worker worker;
    private long lastIdleCheckTime;
    private final Object disposalLock = new Object();
    private volatile boolean disposing;
    private volatile boolean disposed;
    private final DefaultIoFuture disposalFuture = new DefaultIoFuture(null);

    protected AbstractPollingIoProcessor(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.threadName = this.nextThreadName();
        this.executor = executor;
    }

    private String nextThreadName() {
        int newThreadId;
        Class<?> cls = this.getClass();
        AtomicInteger threadId = threadIds.get(cls);
        if (threadId == null) {
            newThreadId = 1;
            threadIds.put(cls, new AtomicInteger(newThreadId));
        } else {
            newThreadId = threadId.incrementAndGet();
        }
        return cls.getSimpleName() + '-' + newThreadId;
    }

    @Override
    public final boolean isDisposing() {
        return this.disposing;
    }

    @Override
    public final boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        if (this.disposed) {
            return;
        }
        Object object = this.disposalLock;
        synchronized (object) {
            if (!this.disposing) {
                this.disposing = true;
                this.startupWorker();
            }
        }
        this.disposalFuture.awaitUninterruptibly();
        this.disposed = true;
    }

    protected abstract void dispose0() throws Exception;

    protected abstract boolean select(int var1) throws Exception;

    protected abstract void wakeup();

    protected abstract Iterator<T> allSessions();

    protected abstract Iterator<T> selectedSessions();

    protected abstract SessionState state(T var1);

    protected abstract boolean isWritable(T var1);

    protected abstract boolean isReadable(T var1);

    protected abstract void setInterestedInWrite(T var1, boolean var2) throws Exception;

    protected abstract void setInterestedInRead(T var1, boolean var2) throws Exception;

    protected abstract boolean isInterestedInRead(T var1);

    protected abstract boolean isInterestedInWrite(T var1);

    protected abstract void init(T var1) throws Exception;

    protected abstract void destroy(T var1) throws Exception;

    protected abstract int read(T var1, IoBuffer var2) throws Exception;

    protected abstract int write(T var1, IoBuffer var2, int var3) throws Exception;

    protected abstract int transferFile(T var1, FileRegion var2, int var3) throws Exception;

    @Override
    public final void add(T session) {
        if (this.isDisposing()) {
            throw new IllegalStateException("Already disposed.");
        }
        this.newSessions.add(session);
        this.startupWorker();
    }

    @Override
    public final void remove(T session) {
        this.scheduleRemove(session);
        this.startupWorker();
    }

    private void scheduleRemove(T session) {
        this.removingSessions.add(session);
    }

    @Override
    public final void flush(T session) {
        boolean needsWakeup = this.flushingSessions.isEmpty();
        if (this.scheduleFlush(session) && needsWakeup) {
            this.wakeup();
        }
    }

    private boolean scheduleFlush(T session) {
        if (((AbstractIoSession)session).setScheduledForFlush(true)) {
            this.flushingSessions.add(session);
            return true;
        }
        return false;
    }

    @Override
    public final void updateTrafficMask(T session) {
        this.scheduleTrafficControl(session);
        this.wakeup();
    }

    private void scheduleTrafficControl(T session) {
        this.trafficControllingSessions.add(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker, this.threadName));
            }
        }
        this.wakeup();
    }

    private int add() {
        AbstractIoSession session;
        int addedSessions = 0;
        while ((session = (AbstractIoSession)this.newSessions.poll()) != null) {
            if (!this.addNow(session)) continue;
            ++addedSessions;
        }
        return addedSessions;
    }

    private boolean addNow(T session) {
        boolean registered = false;
        boolean notified = false;
        try {
            this.init(session);
            registered = true;
            session.getService().getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            ((AbstractIoService)session.getService()).getListeners().fireSessionCreated((IoSession)session);
            notified = true;
        }
        catch (Exception e) {
            if (notified) {
                this.scheduleRemove(session);
                session.getFilterChain().fireExceptionCaught(e);
                this.wakeup();
            }
            ExceptionMonitor.getInstance().exceptionCaught(e);
            try {
                this.destroy(session);
            }
            catch (Exception e1) {
                ExceptionMonitor.getInstance().exceptionCaught(e1);
            }
        }
        return registered;
    }

    private int remove() {
        AbstractIoSession session;
        int removedSessions = 0;
        block5: while ((session = (AbstractIoSession)this.removingSessions.poll()) != null) {
            SessionState state = this.state(session);
            switch (state) {
                case OPEN: {
                    if (!this.removeNow(session)) continue block5;
                    ++removedSessions;
                    continue block5;
                }
                case CLOSED: {
                    continue block5;
                }
                case PREPARING: {
                    this.scheduleRemove(session);
                    return removedSessions;
                }
            }
            throw new IllegalStateException(String.valueOf((Object)state));
        }
        return removedSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeNow(T session) {
        this.clearWriteRequestQueue(session);
        try {
            this.destroy(session);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            session.getFilterChain().fireExceptionCaught(e);
        }
        finally {
            this.clearWriteRequestQueue(session);
            ((AbstractIoService)session.getService()).getListeners().fireSessionDestroyed((IoSession)session);
        }
        return false;
    }

    private void clearWriteRequestQueue(T session) {
        WriteRequestQueue writeRequestQueue = ((AbstractIoSession)session).getWriteRequestQueue();
        ArrayList<WriteRequest> failedRequests = new ArrayList<WriteRequest>();
        WriteRequest req = writeRequestQueue.poll((IoSession)session);
        if (req != null) {
            Object m = req.getMessage();
            if (m instanceof IoBuffer) {
                IoBuffer buf = (IoBuffer)req.getMessage();
                if (buf.hasRemaining()) {
                    buf.reset();
                    failedRequests.add(req);
                } else {
                    session.getFilterChain().fireMessageSent(req);
                }
            } else {
                failedRequests.add(req);
            }
            while ((req = writeRequestQueue.poll((IoSession)session)) != null) {
                failedRequests.add(req);
            }
        }
        if (!failedRequests.isEmpty()) {
            WriteToClosedSessionException cause = new WriteToClosedSessionException(failedRequests);
            for (WriteRequest r : failedRequests) {
                ((AbstractIoSession)session).decreaseScheduledBytesAndMessages(r);
                r.getFuture().setException(cause);
            }
            session.getFilterChain().fireExceptionCaught(cause);
        }
    }

    private void process() throws Exception {
        Iterator<T> i = this.selectedSessions();
        while (i.hasNext()) {
            this.process((AbstractIoSession)i.next());
            i.remove();
        }
    }

    private void process(T session) {
        if (this.isReadable(session) && ((AbstractIoSession)session).getTrafficMask().isReadable()) {
            this.read(session);
        }
        if (this.isWritable(session) && ((AbstractIoSession)session).getTrafficMask().isWritable()) {
            this.scheduleFlush(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(T session) {
        IoSessionConfig config = session.getConfig();
        IoBuffer buf = IoBuffer.allocate(config.getReadBufferSize());
        boolean hasFragmentation = session.getTransportMetadata().hasFragmentation();
        try {
            int ret;
            int readBytes;
            block16: {
                readBytes = 0;
                try {
                    if (hasFragmentation) {
                        while ((ret = this.read(session, buf)) > 0) {
                            readBytes += ret;
                            if (buf.hasRemaining()) continue;
                            break block16;
                        }
                        break block16;
                    }
                    ret = this.read(session, buf);
                    if (ret > 0) {
                        readBytes = ret;
                    }
                }
                finally {
                    buf.flip();
                }
            }
            if (readBytes > 0) {
                session.getFilterChain().fireMessageReceived(buf);
                buf = null;
                if (hasFragmentation) {
                    if (readBytes << 1 < config.getReadBufferSize()) {
                        ((AbstractIoSession)session).decreaseReadBufferSize();
                    } else if (readBytes == config.getReadBufferSize()) {
                        ((AbstractIoSession)session).increaseReadBufferSize();
                    }
                }
            }
            if (ret < 0) {
                this.scheduleRemove(session);
            }
        }
        catch (IOException e) {
            session.getFilterChain().fireExceptionCaught(e);
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                this.scheduleRemove(session);
            }
            session.getFilterChain().fireExceptionCaught(e);
        }
    }

    private void notifyIdleSessions() throws Exception {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastIdleCheckTime >= 1000L) {
            this.lastIdleCheckTime = currentTime;
            IdleStatusChecker.notifyIdleness(this.allSessions(), currentTime);
        }
    }

    private void flush() {
        AbstractIoSession session;
        block7: while ((session = (AbstractIoSession)this.flushingSessions.poll()) != null) {
            session.setScheduledForFlush(false);
            SessionState state = this.state(session);
            switch (state) {
                case OPEN: {
                    try {
                        boolean flushedAll = this.flushNow(session);
                        if (!flushedAll || session.getWriteRequestQueue().isEmpty(session) || session.isScheduledForFlush()) continue block7;
                        this.scheduleFlush(session);
                    }
                    catch (Exception e) {
                        this.scheduleRemove(session);
                        session.getFilterChain().fireExceptionCaught(e);
                    }
                    break;
                }
                case CLOSED: {
                    break;
                }
                case PREPARING: {
                    this.scheduleFlush(session);
                    return;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)state));
                }
            }
        }
    }

    private boolean flushNow(T session) {
        if (!((AbstractIoSession)session).isConnected()) {
            this.scheduleRemove(session);
            return false;
        }
        boolean hasFragmentation = session.getTransportMetadata().hasFragmentation();
        try {
            this.setInterestedInWrite(session, false);
            WriteRequestQueue writeRequestQueue = ((AbstractIoSession)session).getWriteRequestQueue();
            int maxWrittenBytes = session.getConfig().getMaxReadBufferSize() + (session.getConfig().getMaxReadBufferSize() >>> 1);
            int writtenBytes = 0;
            do {
                WriteRequest req;
                if ((req = ((AbstractIoSession)session).getCurrentWriteRequest()) == null) {
                    req = writeRequestQueue.poll((IoSession)session);
                    if (req == null) break;
                    ((AbstractIoSession)session).setCurrentWriteRequest(req);
                }
                int localWrittenBytes = 0;
                Object message = req.getMessage();
                localWrittenBytes = message instanceof IoBuffer ? this.writeBuffer(session, req, hasFragmentation, maxWrittenBytes - writtenBytes) : this.writeFile(session, req, hasFragmentation, maxWrittenBytes - writtenBytes);
                if (localWrittenBytes != 0 && (writtenBytes += localWrittenBytes) < maxWrittenBytes) continue;
                this.setInterestedInWrite(session, true);
                return false;
            } while (writtenBytes < maxWrittenBytes);
        }
        catch (Exception e) {
            session.getFilterChain().fireExceptionCaught(e);
            return false;
        }
        return true;
    }

    private int writeBuffer(T session, WriteRequest req, boolean hasFragmentation, int maxLength) throws Exception {
        IoBuffer buf = (IoBuffer)req.getMessage();
        int localWrittenBytes = 0;
        if (buf.hasRemaining()) {
            int length = hasFragmentation ? Math.min(buf.remaining(), maxLength) : buf.remaining();
            for (int i = 256; i > 0 && (localWrittenBytes = this.write(session, buf, length)) == 0; --i) {
            }
        }
        if (!buf.hasRemaining() || !hasFragmentation && localWrittenBytes != 0) {
            buf.reset();
            this.fireMessageSent(session, req);
        }
        return localWrittenBytes;
    }

    private int writeFile(T session, WriteRequest req, boolean hasFragmentation, int maxLength) throws Exception {
        int localWrittenBytes;
        FileRegion region = (FileRegion)req.getMessage();
        if (region.getCount() > 0L) {
            int length = hasFragmentation ? (int)Math.min(region.getCount(), (long)maxLength) : (int)Math.min(Integer.MAX_VALUE, region.getCount());
            localWrittenBytes = this.transferFile(session, region, length);
            region.setPosition(region.getPosition() + (long)localWrittenBytes);
        } else {
            localWrittenBytes = 0;
        }
        if (region.getCount() <= 0L || !hasFragmentation && localWrittenBytes != 0) {
            this.fireMessageSent(session, req);
        }
        return localWrittenBytes;
    }

    private void fireMessageSent(T session, WriteRequest req) {
        ((AbstractIoSession)session).setCurrentWriteRequest(null);
        session.getFilterChain().fireMessageSent(req);
    }

    private void updateTrafficMask() {
        AbstractIoSession session;
        block5: while ((session = (AbstractIoSession)this.trafficControllingSessions.poll()) != null) {
            SessionState state = this.state(session);
            switch (state) {
                case OPEN: {
                    this.updateTrafficMaskNow(session);
                    continue block5;
                }
                case CLOSED: {
                    continue block5;
                }
                case PREPARING: {
                    this.scheduleTrafficControl(session);
                    return;
                }
            }
            throw new IllegalStateException(String.valueOf((Object)state));
        }
    }

    private void updateTrafficMaskNow(T session) {
        int mask = ((AbstractIoSession)session).getTrafficMask().getInterestOps();
        try {
            this.setInterestedInRead(session, (mask & 1) != 0);
        }
        catch (Exception e) {
            session.getFilterChain().fireExceptionCaught(e);
        }
        try {
            this.setInterestedInWrite(session, !((AbstractIoSession)session).getWriteRequestQueue().isEmpty((IoSession)session) && (mask & 4) != 0);
        }
        catch (Exception e) {
            session.getFilterChain().fireExceptionCaught(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SessionState {
        OPEN,
        CLOSED,
        PREPARING;

    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int nSessions = 0;
            AbstractPollingIoProcessor.this.lastIdleCheckTime = System.currentTimeMillis();
            block12: while (true) {
                try {
                    while (true) {
                        boolean selected = AbstractPollingIoProcessor.this.select(1000);
                        nSessions += AbstractPollingIoProcessor.this.add();
                        AbstractPollingIoProcessor.this.updateTrafficMask();
                        if (selected) {
                            AbstractPollingIoProcessor.this.process();
                        }
                        AbstractPollingIoProcessor.this.flush();
                        AbstractPollingIoProcessor.this.notifyIdleSessions();
                        if ((nSessions -= AbstractPollingIoProcessor.this.remove()) == 0) {
                            Object object = AbstractPollingIoProcessor.this.lock;
                            synchronized (object) {
                                if (AbstractPollingIoProcessor.this.newSessions.isEmpty()) {
                                    AbstractPollingIoProcessor.this.worker = null;
                                    break block12;
                                }
                            }
                        }
                        if (!AbstractPollingIoProcessor.this.isDisposing()) continue;
                        Iterator i = AbstractPollingIoProcessor.this.allSessions();
                        while (i.hasNext()) {
                            AbstractPollingIoProcessor.this.scheduleRemove((AbstractIoSession)i.next());
                        }
                        AbstractPollingIoProcessor.this.wakeup();
                    }
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
            if (AbstractPollingIoProcessor.this.isDisposing()) {
                try {
                    AbstractPollingIoProcessor.this.dispose0();
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                }
                finally {
                    AbstractPollingIoProcessor.this.disposalFuture.setValue(true);
                }
            }
        }
    }
}

