/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.DefaultIoFuture;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIoFuture<E extends IoFuture>
extends DefaultIoFuture {
    private final NotifyingListener listener = new NotifyingListener();
    private final AtomicInteger unnotified = new AtomicInteger();
    private volatile boolean constructionFinished;

    public CompositeIoFuture(Iterable<E> children) {
        super(null);
        for (IoFuture f : children) {
            f.addListener(this.listener);
            this.unnotified.incrementAndGet();
        }
        this.constructionFinished = true;
        if (this.unnotified.get() == 0) {
            this.setValue(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NotifyingListener
    implements IoFutureListener<IoFuture> {
        private NotifyingListener() {
        }

        @Override
        public void operationComplete(IoFuture future) {
            if (CompositeIoFuture.this.unnotified.decrementAndGet() == 0 && CompositeIoFuture.this.constructionFinished) {
                CompositeIoFuture.this.setValue(true);
            }
        }
    }
}

