/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.nio.channels.FileChannel;
import org.apache.mina.common.FileRegion;

public class DefaultFileRegion
implements FileRegion {
    private final FileChannel channel;
    private long originalPosition;
    private long position;
    private long count;

    public DefaultFileRegion(FileChannel channel, long position, long count) {
        if (channel == null) {
            throw new IllegalArgumentException("channel can not be null");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("position may not be less than 0");
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count may not be less than 0");
        }
        this.channel = channel;
        this.originalPosition = position;
        this.position = position;
        this.count = count;
    }

    public long getWrittenBytes() {
        return this.position - this.originalPosition;
    }

    public long getCount() {
        return this.count;
    }

    public FileChannel getFileChannel() {
        return this.channel;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long value) {
        if (value < this.position) {
            throw new IllegalArgumentException("New position value may not be less than old position value");
        }
        this.count -= value - this.position;
        this.position = value;
    }
}

