/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.AbstractIoService;
import org.apache.mina.common.AbstractIoSession;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.common.WriteTimeoutException;
import org.apache.mina.util.ConcurrentHashSet;
import org.apache.mina.util.NamePreservingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdleStatusChecker {
    private static final IdleStatusChecker INSTANCE = new IdleStatusChecker();
    private final Set<AbstractIoSession> sessions = new ConcurrentHashSet<AbstractIoSession>();
    private final Set<AbstractIoService> services = new ConcurrentHashSet<AbstractIoService>();
    private final Object lock = new Object();
    private final Runnable notifyingTask = new NamePreservingRunnable(new NotifyingTask(), "IdleStatusChecker");
    private final IoFutureListener<IoFuture> sessionCloseListener = new SessionCloseListener();
    private volatile ScheduledExecutorService executor;

    public static IdleStatusChecker getInstance() {
        return INSTANCE;
    }

    private IdleStatusChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(AbstractIoSession session) {
        Object object = this.lock;
        synchronized (object) {
            boolean start = false;
            if (this.sessions.isEmpty() && this.services.isEmpty()) {
                start = true;
            }
            if (!this.sessions.add(session)) {
                return;
            }
            if (start) {
                this.start();
            }
        }
        session.getCloseFuture().addListener(this.sessionCloseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(AbstractIoService service) {
        Object object = this.lock;
        synchronized (object) {
            boolean start = false;
            if (this.sessions.isEmpty() && this.services.isEmpty()) {
                start = true;
            }
            if (!this.services.add(service)) {
                return;
            }
            if (start) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(AbstractIoSession session) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.remove(session);
            if (this.sessions.isEmpty() && this.services.isEmpty()) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(AbstractIoService service) {
        Object object = this.lock;
        synchronized (object) {
            this.services.remove(service);
            if (this.sessions.isEmpty() && this.services.isEmpty()) {
                this.stop();
            }
        }
    }

    private void start() {
        ScheduledExecutorService executor;
        this.executor = executor = Executors.newScheduledThreadPool(1);
        executor.scheduleWithFixedDelay(this.notifyingTask, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void stop() {
        ScheduledExecutorService executor = this.executor;
        if (executor == null) {
            return;
        }
        executor.shutdownNow();
        this.executor = null;
    }

    public static void notifyIdleness(Iterator<? extends IoSession> sessions, long currentTime) {
        IoSession s = null;
        while (sessions.hasNext()) {
            s = sessions.next();
            IdleStatusChecker.notifyIdleSession(s, currentTime);
        }
    }

    public static void notifyIdleness(IoService service, long currentTime) {
        IdleStatusChecker.notifyIdleness(service, currentTime, true);
    }

    private static void notifyIdleness(IoService service, long currentTime, boolean includeSessions) {
        if (!(service instanceof AbstractIoService)) {
            return;
        }
        ((AbstractIoService)service).notifyIdleness(currentTime);
        if (includeSessions) {
            IdleStatusChecker.notifyIdleness(service.getManagedSessions().iterator(), currentTime);
        }
    }

    public static void notifyIdleSession(IoSession session, long currentTime) {
        if (session instanceof AbstractIoSession) {
            AbstractIoSession s = (AbstractIoSession)session;
            IdleStatusChecker.notifyIdleSession1(s, currentTime, s.getConfig().getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(s.getLastIoTime(), s.getLastIdleTime(IdleStatus.BOTH_IDLE)));
            IdleStatusChecker.notifyIdleSession1(s, currentTime, s.getConfig().getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(s.getLastReadTime(), s.getLastIdleTime(IdleStatus.READER_IDLE)));
            IdleStatusChecker.notifyIdleSession1(s, currentTime, s.getConfig().getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(s.getLastWriteTime(), s.getLastIdleTime(IdleStatus.WRITER_IDLE)));
            IdleStatusChecker.notifyWriteTimeout(s, currentTime);
            IdleStatusChecker.updateThroughput(s, currentTime);
        } else {
            IdleStatusChecker.notifyIdleSession0(session, currentTime, session.getConfig().getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
            IdleStatusChecker.notifyIdleSession0(session, currentTime, session.getConfig().getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(session.getLastReadTime(), session.getLastIdleTime(IdleStatus.READER_IDLE)));
            IdleStatusChecker.notifyIdleSession0(session, currentTime, session.getConfig().getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(session.getLastWriteTime(), session.getLastIdleTime(IdleStatus.WRITER_IDLE)));
        }
    }

    private static void notifyIdleSession0(IoSession session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.getFilterChain().fireSessionIdle(status);
        }
    }

    private static void notifyIdleSession1(AbstractIoSession session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.getFilterChain().fireSessionIdle(status);
        }
    }

    private static void notifyWriteTimeout(AbstractIoSession session, long currentTime) {
        WriteRequest request;
        long writeTimeout = session.getConfig().getWriteTimeoutInMillis();
        if (writeTimeout > 0L && currentTime - session.getLastWriteTime() >= writeTimeout && !session.getWriteRequestQueue().isEmpty(session) && (request = session.getCurrentWriteRequest()) != null) {
            session.setCurrentWriteRequest(null);
            WriteTimeoutException cause = new WriteTimeoutException(request);
            request.getFuture().setException(cause);
            session.getFilterChain().fireExceptionCaught(cause);
            session.close();
        }
    }

    private static void updateThroughput(AbstractIoSession session, long currentTime) {
        session.updateThroughput(currentTime, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SessionCloseListener
    implements IoFutureListener<IoFuture> {
        private SessionCloseListener() {
        }

        @Override
        public void operationComplete(IoFuture future) {
            IdleStatusChecker.this.removeSession((AbstractIoSession)future.getSession());
        }
    }

    private class NotifyingTask
    implements Runnable {
        private NotifyingTask() {
        }

        public void run() {
            long currentTime = System.currentTimeMillis();
            this.notifyServices(currentTime);
            this.notifySessions(currentTime);
        }

        private void notifyServices(long currentTime) {
            for (AbstractIoService service : IdleStatusChecker.this.services) {
                if (!service.isActive()) continue;
                IdleStatusChecker.notifyIdleness(service, currentTime, false);
            }
        }

        private void notifySessions(long currentTime) {
            for (AbstractIoSession session : IdleStatusChecker.this.sessions) {
                if (!session.isConnected()) continue;
                IdleStatusChecker.notifyIdleSession(session, currentTime);
            }
        }
    }
}

