/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import org.apache.mina.common.AttributeKey;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoSessionLogger
implements Logger {
    private static final String UNEXPECTED_EXCEPTION = "Unexpected exception.";
    private static final AttributeKey PREFIX = new AttributeKey(IoSessionLogger.class, "prefix");
    private static boolean usePrefix = true;
    private final IoSession session;
    private final Logger logger;

    public static IoSessionLogger getLogger(IoSession session) {
        return IoSessionLogger.getLogger(session, session.getHandler().getClass());
    }

    public static IoSessionLogger getLogger(IoSession session, String name) {
        if (name != null) {
            return IoSessionLogger.getLogger(session, LoggerFactory.getLogger((String)name));
        }
        return IoSessionLogger.getLogger(session, (Logger)null);
    }

    public static IoSessionLogger getLogger(IoSession session, Class<?> clazz) {
        if (clazz != null) {
            return IoSessionLogger.getLogger(session, LoggerFactory.getLogger(clazz));
        }
        return IoSessionLogger.getLogger(session, (Logger)null);
    }

    public static IoSessionLogger getLogger(IoSession session, Logger logger) {
        IoSessionLogger newDecoratedLogger;
        IoSessionLogger decoratedLogger;
        if (logger == null) {
            logger = LoggerFactory.getLogger(session.getHandler().getClass());
        }
        if ((decoratedLogger = (IoSessionLogger)session.getAttribute(logger)) == null && (newDecoratedLogger = (IoSessionLogger)session.setAttributeIfAbsent(logger, decoratedLogger = new IoSessionLogger(session, logger))) != null) {
            decoratedLogger = newDecoratedLogger;
        }
        return decoratedLogger;
    }

    public static boolean isUsePrefix() {
        return usePrefix;
    }

    public static void setUsePrefix(boolean usePrefix) {
        IoSessionLogger.usePrefix = usePrefix;
    }

    public static String getPrefix(IoSession session) {
        String prefix = (String)session.getAttribute(PREFIX);
        if (prefix == null) {
            return "";
        }
        return prefix;
    }

    public static void setPrefix(IoSession session, String prefix) {
        if (prefix == null || !usePrefix) {
            IoSessionLogger.removePrefix(session);
            return;
        }
        if (prefix.contains("{}")) {
            throw new IllegalArgumentException("prefix cannot contain '{}': " + prefix);
        }
        session.setAttribute(PREFIX, prefix);
    }

    public static void removePrefix(IoSession session) {
        session.removeAttribute(PREFIX);
    }

    private IoSessionLogger(IoSession session, Logger logger) {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        this.session = session;
        this.logger = logger;
        if (usePrefix && !session.containsAttribute(PREFIX)) {
            session.setAttributeIfAbsent(PREFIX, "[" + session.getRemoteAddress() + "] ");
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(marker, IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(marker, IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object[] args) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(marker, IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.debug(marker, format, args);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(marker, IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.debug(marker, msg, t);
        }
    }

    public void debug(Marker marker, String msg) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(marker, IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.debug(marker, msg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object arg) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.debug(format, arg);
        }
    }

    public void debug(String format, Object[] args) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.debug(format, args);
        }
    }

    public void debug(String msg, Throwable t) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.debug(msg, t);
        }
    }

    public void debug(Throwable t) {
        this.debug(UNEXPECTED_EXCEPTION, t);
    }

    public void debug(String msg) {
        if (usePrefix) {
            if (this.isDebugEnabled()) {
                this.logger.debug(IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.debug(msg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(marker, IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(marker, IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object[] args) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(marker, IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.error(marker, format, args);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(marker, IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.error(marker, msg, t);
        }
    }

    public void error(Marker marker, String msg) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(marker, IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.error(marker, msg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.error(format, arg1, arg2);
        }
    }

    public void error(String format, Object arg) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.error(format, arg);
        }
    }

    public void error(String format, Object[] args) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.error(format, args);
        }
    }

    public void error(String msg, Throwable t) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.error(msg, t);
        }
    }

    public void error(Throwable t) {
        this.error(UNEXPECTED_EXCEPTION, t);
    }

    public void error(String msg) {
        if (usePrefix) {
            if (this.isErrorEnabled()) {
                this.logger.error(IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.error(msg);
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(marker, IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(marker, IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object[] args) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(marker, IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.info(marker, format, args);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(marker, IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.info(marker, msg, t);
        }
    }

    public void info(Marker marker, String msg) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(marker, IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.info(marker, msg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.info(format, arg1, arg2);
        }
    }

    public void info(String format, Object arg) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.info(format, arg);
        }
    }

    public void info(String format, Object[] args) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.info(format, args);
        }
    }

    public void info(String msg, Throwable t) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.info(msg, t);
        }
    }

    public void info(Throwable t) {
        this.info(UNEXPECTED_EXCEPTION, t);
    }

    public void info(String msg) {
        if (usePrefix) {
            if (this.isInfoEnabled()) {
                this.logger.info(IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.info(msg);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(marker, IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(marker, IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object[] args) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(marker, IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.trace(marker, format, args);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(marker, IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.trace(marker, msg, t);
        }
    }

    public void trace(Marker marker, String msg) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(marker, IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.trace(marker, msg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object arg) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.trace(format, arg);
        }
    }

    public void trace(String format, Object[] args) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.trace(format, args);
        }
    }

    public void trace(String msg, Throwable t) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.trace(msg, t);
        }
    }

    public void trace(Throwable t) {
        this.trace(UNEXPECTED_EXCEPTION, t);
    }

    public void trace(String msg) {
        if (usePrefix) {
            if (this.isTraceEnabled()) {
                this.logger.trace(IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.trace(msg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(marker, IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(marker, IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object[] args) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(marker, IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.warn(marker, format, args);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(marker, IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.warn(marker, msg, t);
        }
    }

    public void warn(Marker marker, String msg) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(marker, IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.warn(marker, msg);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(IoSessionLogger.getPrefix(this.session) + format, arg1, arg2);
            }
        } else {
            this.logger.warn(format, arg1, arg2);
        }
    }

    public void warn(String format, Object arg) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(IoSessionLogger.getPrefix(this.session) + format, arg);
            }
        } else {
            this.logger.warn(format, arg);
        }
    }

    public void warn(String format, Object[] args) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(IoSessionLogger.getPrefix(this.session) + format, args);
            }
        } else {
            this.logger.warn(format, args);
        }
    }

    public void warn(String msg, Throwable t) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(IoSessionLogger.getPrefix(this.session) + msg, t);
            }
        } else {
            this.logger.warn(msg, t);
        }
    }

    public void warn(Throwable t) {
        this.warn(UNEXPECTED_EXCEPTION, t);
    }

    public void warn(String msg) {
        if (usePrefix) {
            if (this.isWarnEnabled()) {
                this.logger.warn(IoSessionLogger.getPrefix(this.session) + msg);
            }
        } else {
            this.logger.warn(msg);
        }
    }

    public String toString() {
        return this.logger.toString();
    }
}

