/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.util.Queue;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.util.CircularQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final Queue<IoBuffer> bufferQueue = new CircularQueue<IoBuffer>();

    public Queue<IoBuffer> getBufferQueue() {
        return this.bufferQueue;
    }

    @Override
    public void write(IoBuffer buf) {
        if (!buf.hasRemaining()) {
            throw new IllegalArgumentException("buf is empty. Forgot to call flip()?");
        }
        this.bufferQueue.add(buf);
    }

    @Override
    public void mergeAll() {
        IoBuffer buf;
        int size = this.bufferQueue.size();
        if (size < 2) {
            return;
        }
        int sum = 0;
        for (IoBuffer b : this.bufferQueue) {
            sum += b.remaining();
        }
        IoBuffer newBuf = IoBuffer.allocate(sum);
        while ((buf = this.bufferQueue.poll()) != null) {
            newBuf.put(buf);
        }
        newBuf.flip();
        this.bufferQueue.add(newBuf);
    }
}

